<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Name StructType
 * @subpackage Structs
 */
class Name extends AbstractStructBase
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Category;
    /**
     * The NumberOfItem
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $NumberOfItem;
    /**
     * Constructor method for Name
     * @uses Name::setCategory()
     * @uses Name::setNumberOfItem()
     * @param string $category
     * @param int $numberOfItem
     */
    public function __construct($category = null, $numberOfItem = null)
    {
        $this
            ->setCategory($category)
            ->setNumberOfItem($numberOfItem);
    }
    /**
     * Get Category value
     * @return string
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\Name
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get NumberOfItem value
     * @return int
     */
    public function getNumberOfItem()
    {
        return $this->NumberOfItem;
    }
    /**
     * Set NumberOfItem value
     * @param int $numberOfItem
     * @return \StructType\Name
     */
    public function setNumberOfItem($numberOfItem = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfItem) && !(is_int($numberOfItem) || ctype_digit($numberOfItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfItem, true), gettype($numberOfItem)), __LINE__);
        }
        $this->NumberOfItem = $numberOfItem;
        return $this;
    }
}
