<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contributor StructType
 * @subpackage Structs
 */
class Contributor extends AbstractStructBase
{
    /**
     * The contributorRole
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: hns:contributorRole
     * @var \StructType\ContributorRole[]
     */
    public $contributorRole;
    /**
     * Constructor method for contributor
     * @uses Contributor::setContributorRole()
     * @param \StructType\ContributorRole[] $contributorRole
     */
    public function __construct(array $contributorRole = array())
    {
        $this
            ->setContributorRole($contributorRole);
    }
    /**
     * Get contributorRole value
     * @return \StructType\ContributorRole[]|null
     */
    public function getContributorRole()
    {
        return $this->contributorRole;
    }
    /**
     * This method is responsible for validating the values passed to the setContributorRole method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContributorRole method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContributorRoleForArrayConstraintsFromSetContributorRole(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contributorContributorRoleItem) {
            // validation for constraint: itemType
            if (!$contributorContributorRoleItem instanceof \StructType\ContributorRole) {
                $invalidValues[] = is_object($contributorContributorRoleItem) ? get_class($contributorContributorRoleItem) : sprintf('%s(%s)', gettype($contributorContributorRoleItem), var_export($contributorContributorRoleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contributorRole property can only contain items of type \StructType\ContributorRole, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contributorRole value
     * @throws \InvalidArgumentException
     * @param \StructType\ContributorRole[] $contributorRole
     * @return \StructType\Contributor
     */
    public function setContributorRole(array $contributorRole = array())
    {
        // validation for constraint: array
        if ('' !== ($contributorRoleArrayErrorMessage = self::validateContributorRoleForArrayConstraintsFromSetContributorRole($contributorRole))) {
            throw new \InvalidArgumentException($contributorRoleArrayErrorMessage, __LINE__);
        }
        $this->contributorRole = $contributorRole;
        return $this;
    }
    /**
     * Add item to contributorRole value
     * @throws \InvalidArgumentException
     * @param \StructType\ContributorRole $item
     * @return \StructType\Contributor
     */
    public function addToContributorRole(\StructType\ContributorRole $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContributorRole) {
            throw new \InvalidArgumentException(sprintf('The contributorRole property can only contain items of type \StructType\ContributorRole, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contributorRole[] = $item;
        return $this;
    }
}
