<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for picture StructType
 * @subpackage Structs
 */
class Picture extends AbstractStructBase
{
    /**
     * The frontCoverLarge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:frontCoverLarge
     * @var string
     */
    public $frontCoverLarge;
    /**
     * The frontCoverMedium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:frontCoverMedium
     * @var string
     */
    public $frontCoverMedium;
    /**
     * The frontCoverSmall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:frontCoverSmall
     * @var string
     */
    public $frontCoverSmall;
    /**
     * The backCover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:backCover
     * @var string
     */
    public $backCover;
    /**
     * The sampleContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * - ref: hns:sampleContent
     * @var string[]
     */
    public $sampleContent;
    /**
     * Constructor method for picture
     * @uses Picture::setFrontCoverLarge()
     * @uses Picture::setFrontCoverMedium()
     * @uses Picture::setFrontCoverSmall()
     * @uses Picture::setBackCover()
     * @uses Picture::setSampleContent()
     * @param string $frontCoverLarge
     * @param string $frontCoverMedium
     * @param string $frontCoverSmall
     * @param string $backCover
     * @param string[] $sampleContent
     */
    public function __construct($frontCoverLarge = null, $frontCoverMedium = null, $frontCoverSmall = null, $backCover = null, array $sampleContent = array())
    {
        $this
            ->setFrontCoverLarge($frontCoverLarge)
            ->setFrontCoverMedium($frontCoverMedium)
            ->setFrontCoverSmall($frontCoverSmall)
            ->setBackCover($backCover)
            ->setSampleContent($sampleContent);
    }
    /**
     * Get frontCoverLarge value
     * @return string|null
     */
    public function getFrontCoverLarge()
    {
        return $this->frontCoverLarge;
    }
    /**
     * Set frontCoverLarge value
     * @param string $frontCoverLarge
     * @return \StructType\Picture
     */
    public function setFrontCoverLarge($frontCoverLarge = null)
    {
        // validation for constraint: string
        if (!is_null($frontCoverLarge) && !is_string($frontCoverLarge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frontCoverLarge, true), gettype($frontCoverLarge)), __LINE__);
        }
        $this->frontCoverLarge = $frontCoverLarge;
        return $this;
    }
    /**
     * Get frontCoverMedium value
     * @return string|null
     */
    public function getFrontCoverMedium()
    {
        return $this->frontCoverMedium;
    }
    /**
     * Set frontCoverMedium value
     * @param string $frontCoverMedium
     * @return \StructType\Picture
     */
    public function setFrontCoverMedium($frontCoverMedium = null)
    {
        // validation for constraint: string
        if (!is_null($frontCoverMedium) && !is_string($frontCoverMedium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frontCoverMedium, true), gettype($frontCoverMedium)), __LINE__);
        }
        $this->frontCoverMedium = $frontCoverMedium;
        return $this;
    }
    /**
     * Get frontCoverSmall value
     * @return string|null
     */
    public function getFrontCoverSmall()
    {
        return $this->frontCoverSmall;
    }
    /**
     * Set frontCoverSmall value
     * @param string $frontCoverSmall
     * @return \StructType\Picture
     */
    public function setFrontCoverSmall($frontCoverSmall = null)
    {
        // validation for constraint: string
        if (!is_null($frontCoverSmall) && !is_string($frontCoverSmall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frontCoverSmall, true), gettype($frontCoverSmall)), __LINE__);
        }
        $this->frontCoverSmall = $frontCoverSmall;
        return $this;
    }
    /**
     * Get backCover value
     * @return string|null
     */
    public function getBackCover()
    {
        return $this->backCover;
    }
    /**
     * Set backCover value
     * @param string $backCover
     * @return \StructType\Picture
     */
    public function setBackCover($backCover = null)
    {
        // validation for constraint: string
        if (!is_null($backCover) && !is_string($backCover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backCover, true), gettype($backCover)), __LINE__);
        }
        $this->backCover = $backCover;
        return $this;
    }
    /**
     * Get sampleContent value
     * @return string[]|null
     */
    public function getSampleContent()
    {
        return $this->sampleContent;
    }
    /**
     * This method is responsible for validating the values passed to the setSampleContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSampleContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSampleContentForArrayConstraintsFromSetSampleContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pictureSampleContentItem) {
            // validation for constraint: itemType
            if (!is_string($pictureSampleContentItem)) {
                $invalidValues[] = is_object($pictureSampleContentItem) ? get_class($pictureSampleContentItem) : sprintf('%s(%s)', gettype($pictureSampleContentItem), var_export($pictureSampleContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sampleContent property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sampleContent value
     * @throws \InvalidArgumentException
     * @param string[] $sampleContent
     * @return \StructType\Picture
     */
    public function setSampleContent(array $sampleContent = array())
    {
        // validation for constraint: array
        if ('' !== ($sampleContentArrayErrorMessage = self::validateSampleContentForArrayConstraintsFromSetSampleContent($sampleContent))) {
            throw new \InvalidArgumentException($sampleContentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($sampleContent) && count($sampleContent) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($sampleContent)), __LINE__);
        }
        $this->sampleContent = $sampleContent;
        return $this;
    }
    /**
     * Add item to sampleContent value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Picture
     */
    public function addToSampleContent($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The sampleContent property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->sampleContent) && count($this->sampleContent) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->sampleContent)), __LINE__);
        }
        $this->sampleContent[] = $item;
        return $this;
    }
}
