<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pagination StructType
 * @subpackage Structs
 */
class Pagination extends AbstractStructBase
{
    /**
     * The nbResultsPerPage
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - default: 15
     * - maxInclusive: 30
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $nbResultsPerPage;
    /**
     * The currentPage
     * Meta information extracted from the WSDL
     * - default: 1
     * - minOccurs: 0
     * @var int
     */
    public $currentPage;
    /**
     * The sortBy
     * Meta information extracted from the WSDL
     * - default: RELEVANCE
     * - minOccurs: 0
     * @var string
     */
    public $sortBy;
    /**
     * The sortOrder
     * Meta information extracted from the WSDL
     * - default: DESCENDING
     * - minOccurs: 0
     * @var string
     */
    public $sortOrder;
    /**
     * The includeNotice
     * Meta information extracted from the WSDL
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $includeNotice;
    /**
     * Constructor method for pagination
     * @uses Pagination::setNbResultsPerPage()
     * @uses Pagination::setCurrentPage()
     * @uses Pagination::setSortBy()
     * @uses Pagination::setSortOrder()
     * @uses Pagination::setIncludeNotice()
     * @param int $nbResultsPerPage
     * @param int $currentPage
     * @param string $sortBy
     * @param string $sortOrder
     * @param bool $includeNotice
     */
    public function __construct($nbResultsPerPage = 15, $currentPage = 1, $sortBy = 'RELEVANCE', $sortOrder = 'DESCENDING', $includeNotice = false)
    {
        $this
            ->setNbResultsPerPage($nbResultsPerPage)
            ->setCurrentPage($currentPage)
            ->setSortBy($sortBy)
            ->setSortOrder($sortOrder)
            ->setIncludeNotice($includeNotice);
    }
    /**
     * Get nbResultsPerPage value
     * @return int|null
     */
    public function getNbResultsPerPage()
    {
        return $this->nbResultsPerPage;
    }
    /**
     * Set nbResultsPerPage value
     * @param int $nbResultsPerPage
     * @return \StructType\Pagination
     */
    public function setNbResultsPerPage($nbResultsPerPage = 15)
    {
        // validation for constraint: int
        if (!is_null($nbResultsPerPage) && !(is_int($nbResultsPerPage) || ctype_digit($nbResultsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbResultsPerPage, true), gettype($nbResultsPerPage)), __LINE__);
        }
        // validation for constraint: maxInclusive(30)
        if (!is_null($nbResultsPerPage) && $nbResultsPerPage > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 30', var_export($nbResultsPerPage, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($nbResultsPerPage) && $nbResultsPerPage < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($nbResultsPerPage, true)), __LINE__);
        }
        $this->nbResultsPerPage = $nbResultsPerPage;
        return $this;
    }
    /**
     * Get currentPage value
     * @return int|null
     */
    public function getCurrentPage()
    {
        return $this->currentPage;
    }
    /**
     * Set currentPage value
     * @param int $currentPage
     * @return \StructType\Pagination
     */
    public function setCurrentPage($currentPage = 1)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->currentPage = $currentPage;
        return $this;
    }
    /**
     * Get sortBy value
     * @return string|null
     */
    public function getSortBy()
    {
        return $this->sortBy;
    }
    /**
     * Set sortBy value
     * @param string $sortBy
     * @return \StructType\Pagination
     */
    public function setSortBy($sortBy = 'RELEVANCE')
    {
        // validation for constraint: string
        if (!is_null($sortBy) && !is_string($sortBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortBy, true), gettype($sortBy)), __LINE__);
        }
        $this->sortBy = $sortBy;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses \EnumType\SortOrder::valueIsValid()
     * @uses \EnumType\SortOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \StructType\Pagination
     */
    public function setSortOrder($sortOrder = 'DESCENDING')
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortOrder::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SortOrder', is_array($sortOrder) ? implode(', ', $sortOrder) : var_export($sortOrder, true), implode(', ', \EnumType\SortOrder::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get includeNotice value
     * @return bool|null
     */
    public function getIncludeNotice()
    {
        return $this->includeNotice;
    }
    /**
     * Set includeNotice value
     * @param bool $includeNotice
     * @return \StructType\Pagination
     */
    public function setIncludeNotice($includeNotice = false)
    {
        // validation for constraint: boolean
        if (!is_null($includeNotice) && !is_bool($includeNotice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeNotice, true), gettype($includeNotice)), __LINE__);
        }
        $this->includeNotice = $includeNotice;
        return $this;
    }
}
