<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MAT StructType
 * @subpackage Structs
 */
class MAT extends AbstractStructBase
{
    /**
     * The GTIN13
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9]{13}
     * - ref: hns:GTIN13
     * @var string
     */
    public $GTIN13;
    /**
     * The productRelation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:productRelation
     * @var string
     */
    public $productRelation;
    /**
     * Constructor method for MAT
     * @uses MAT::setGTIN13()
     * @uses MAT::setProductRelation()
     * @param string $gTIN13
     * @param string $productRelation
     */
    public function __construct($gTIN13 = null, $productRelation = null)
    {
        $this
            ->setGTIN13($gTIN13)
            ->setProductRelation($productRelation);
    }
    /**
     * Get GTIN13 value
     * @return string|null
     */
    public function getGTIN13()
    {
        return $this->GTIN13;
    }
    /**
     * Set GTIN13 value
     * @param string $gTIN13
     * @return \StructType\MAT
     */
    public function setGTIN13($gTIN13 = null)
    {
        // validation for constraint: string
        if (!is_null($gTIN13) && !is_string($gTIN13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gTIN13, true), gettype($gTIN13)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{13})
        if (!is_null($gTIN13) && !preg_match('/[0-9]{13}/', $gTIN13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{13}', var_export($gTIN13, true)), __LINE__);
        }
        $this->GTIN13 = $gTIN13;
        return $this;
    }
    /**
     * Get productRelation value
     * @return string|null
     */
    public function getProductRelation()
    {
        return $this->productRelation;
    }
    /**
     * Set productRelation value
     * @param string $productRelation
     * @return \StructType\MAT
     */
    public function setProductRelation($productRelation = null)
    {
        // validation for constraint: string
        if (!is_null($productRelation) && !is_string($productRelation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productRelation, true), gettype($productRelation)), __LINE__);
        }
        $this->productRelation = $productRelation;
        return $this;
    }
}
