<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for descriptiveDetail StructType
 * @subpackage Structs
 */
class DescriptiveDetail extends AbstractStructBase
{
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:productType
     * @var string
     */
    public $productType;
    /**
     * The productForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:productForm
     * @var string
     */
    public $productForm;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:height
     * @var string
     */
    public $height;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:width
     * @var string
     */
    public $width;
    /**
     * The thickness
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:thickness
     * @var string
     */
    public $thickness;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:weight
     * @var string
     */
    public $weight;
    /**
     * The pagesNumber
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 99999
     * - minInclusive: 1
     * - minOccurs: 0
     * - ref: hns:pagesNumber
     * @var int
     */
    public $pagesNumber;
    /**
     * The numberOfIllustrations
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - minOccurs: 0
     * - ref: hns:numberOfIllustrations
     * @var int
     */
    public $numberOfIllustrations;
    /**
     * Constructor method for descriptiveDetail
     * @uses DescriptiveDetail::setProductType()
     * @uses DescriptiveDetail::setProductForm()
     * @uses DescriptiveDetail::setHeight()
     * @uses DescriptiveDetail::setWidth()
     * @uses DescriptiveDetail::setThickness()
     * @uses DescriptiveDetail::setWeight()
     * @uses DescriptiveDetail::setPagesNumber()
     * @uses DescriptiveDetail::setNumberOfIllustrations()
     * @param string $productType
     * @param string $productForm
     * @param string $height
     * @param string $width
     * @param string $thickness
     * @param string $weight
     * @param int $pagesNumber
     * @param int $numberOfIllustrations
     */
    public function __construct($productType = null, $productForm = null, $height = null, $width = null, $thickness = null, $weight = null, $pagesNumber = null, $numberOfIllustrations = null)
    {
        $this
            ->setProductType($productType)
            ->setProductForm($productForm)
            ->setHeight($height)
            ->setWidth($width)
            ->setThickness($thickness)
            ->setWeight($weight)
            ->setPagesNumber($pagesNumber)
            ->setNumberOfIllustrations($numberOfIllustrations);
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \StructType\DescriptiveDetail
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get productForm value
     * @return string|null
     */
    public function getProductForm()
    {
        return $this->productForm;
    }
    /**
     * Set productForm value
     * @param string $productForm
     * @return \StructType\DescriptiveDetail
     */
    public function setProductForm($productForm = null)
    {
        // validation for constraint: string
        if (!is_null($productForm) && !is_string($productForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productForm, true), gettype($productForm)), __LINE__);
        }
        $this->productForm = $productForm;
        return $this;
    }
    /**
     * Get height value
     * @return string|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param string $height
     * @return \StructType\DescriptiveDetail
     */
    public function setHeight($height = null)
    {
        // validation for constraint: string
        if (!is_null($height) && !is_string($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get width value
     * @return string|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param string $width
     * @return \StructType\DescriptiveDetail
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get thickness value
     * @return string|null
     */
    public function getThickness()
    {
        return $this->thickness;
    }
    /**
     * Set thickness value
     * @param string $thickness
     * @return \StructType\DescriptiveDetail
     */
    public function setThickness($thickness = null)
    {
        // validation for constraint: string
        if (!is_null($thickness) && !is_string($thickness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thickness, true), gettype($thickness)), __LINE__);
        }
        $this->thickness = $thickness;
        return $this;
    }
    /**
     * Get weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param string $weight
     * @return \StructType\DescriptiveDetail
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get pagesNumber value
     * @return int|null
     */
    public function getPagesNumber()
    {
        return $this->pagesNumber;
    }
    /**
     * Set pagesNumber value
     * @param int $pagesNumber
     * @return \StructType\DescriptiveDetail
     */
    public function setPagesNumber($pagesNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pagesNumber) && !(is_int($pagesNumber) || ctype_digit($pagesNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pagesNumber, true), gettype($pagesNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(99999)
        if (!is_null($pagesNumber) && $pagesNumber > 99999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999', var_export($pagesNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($pagesNumber) && $pagesNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($pagesNumber, true)), __LINE__);
        }
        $this->pagesNumber = $pagesNumber;
        return $this;
    }
    /**
     * Get numberOfIllustrations value
     * @return int|null
     */
    public function getNumberOfIllustrations()
    {
        return $this->numberOfIllustrations;
    }
    /**
     * Set numberOfIllustrations value
     * @param int $numberOfIllustrations
     * @return \StructType\DescriptiveDetail
     */
    public function setNumberOfIllustrations($numberOfIllustrations = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfIllustrations) && !(is_int($numberOfIllustrations) || ctype_digit($numberOfIllustrations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfIllustrations, true), gettype($numberOfIllustrations)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($numberOfIllustrations) && $numberOfIllustrations > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($numberOfIllustrations, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($numberOfIllustrations) && $numberOfIllustrations < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($numberOfIllustrations, true)), __LINE__);
        }
        $this->numberOfIllustrations = $numberOfIllustrations;
        return $this;
    }
}
