<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contributorRole StructType
 * @subpackage Structs
 */
class ContributorRole extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Description;
    /**
     * The keyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:keyName
     * @var string
     */
    public $keyName;
    /**
     * The nameBeforeKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:nameBeforeKey
     * @var string
     */
    public $nameBeforeKey;
    /**
     * The ISNI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 16
     * - minOccurs: 0
     * - ref: hns:ISNI
     * @var string
     */
    public $ISNI;
    /**
     * The contributorAuthorityNumber
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9]{8}
     * - ref: hns:contributorAuthorityNumber
     * @var string
     */
    public $contributorAuthorityNumber;
    /**
     * The biographicalNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:biographicalNote
     * @var string
     */
    public $biographicalNote;
    /**
     * Constructor method for contributorRole
     * @uses ContributorRole::setDescription()
     * @uses ContributorRole::setKeyName()
     * @uses ContributorRole::setNameBeforeKey()
     * @uses ContributorRole::setISNI()
     * @uses ContributorRole::setContributorAuthorityNumber()
     * @uses ContributorRole::setBiographicalNote()
     * @param string $description
     * @param string $keyName
     * @param string $nameBeforeKey
     * @param string $iSNI
     * @param string $contributorAuthorityNumber
     * @param string $biographicalNote
     */
    public function __construct($description = null, $keyName = null, $nameBeforeKey = null, $iSNI = null, $contributorAuthorityNumber = null, $biographicalNote = null)
    {
        $this
            ->setDescription($description)
            ->setKeyName($keyName)
            ->setNameBeforeKey($nameBeforeKey)
            ->setISNI($iSNI)
            ->setContributorAuthorityNumber($contributorAuthorityNumber)
            ->setBiographicalNote($biographicalNote);
    }
    /**
     * Get Description value
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ContributorRole
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get keyName value
     * @return string|null
     */
    public function getKeyName()
    {
        return $this->keyName;
    }
    /**
     * Set keyName value
     * @param string $keyName
     * @return \StructType\ContributorRole
     */
    public function setKeyName($keyName = null)
    {
        // validation for constraint: string
        if (!is_null($keyName) && !is_string($keyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyName, true), gettype($keyName)), __LINE__);
        }
        $this->keyName = $keyName;
        return $this;
    }
    /**
     * Get nameBeforeKey value
     * @return string|null
     */
    public function getNameBeforeKey()
    {
        return $this->nameBeforeKey;
    }
    /**
     * Set nameBeforeKey value
     * @param string $nameBeforeKey
     * @return \StructType\ContributorRole
     */
    public function setNameBeforeKey($nameBeforeKey = null)
    {
        // validation for constraint: string
        if (!is_null($nameBeforeKey) && !is_string($nameBeforeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameBeforeKey, true), gettype($nameBeforeKey)), __LINE__);
        }
        $this->nameBeforeKey = $nameBeforeKey;
        return $this;
    }
    /**
     * Get ISNI value
     * @return string|null
     */
    public function getISNI()
    {
        return $this->ISNI;
    }
    /**
     * Set ISNI value
     * @param string $iSNI
     * @return \StructType\ContributorRole
     */
    public function setISNI($iSNI = null)
    {
        // validation for constraint: string
        if (!is_null($iSNI) && !is_string($iSNI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSNI, true), gettype($iSNI)), __LINE__);
        }
        // validation for constraint: length(16)
        if (!is_null($iSNI) && mb_strlen($iSNI) !== 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 16', mb_strlen($iSNI)), __LINE__);
        }
        $this->ISNI = $iSNI;
        return $this;
    }
    /**
     * Get contributorAuthorityNumber value
     * @return string|null
     */
    public function getContributorAuthorityNumber()
    {
        return $this->contributorAuthorityNumber;
    }
    /**
     * Set contributorAuthorityNumber value
     * @param string $contributorAuthorityNumber
     * @return \StructType\ContributorRole
     */
    public function setContributorAuthorityNumber($contributorAuthorityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contributorAuthorityNumber) && !is_string($contributorAuthorityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contributorAuthorityNumber, true), gettype($contributorAuthorityNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{8})
        if (!is_null($contributorAuthorityNumber) && !preg_match('/[0-9]{8}/', $contributorAuthorityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{8}', var_export($contributorAuthorityNumber, true)), __LINE__);
        }
        $this->contributorAuthorityNumber = $contributorAuthorityNumber;
        return $this;
    }
    /**
     * Get biographicalNote value
     * @return string|null
     */
    public function getBiographicalNote()
    {
        return $this->biographicalNote;
    }
    /**
     * Set biographicalNote value
     * @param string $biographicalNote
     * @return \StructType\ContributorRole
     */
    public function setBiographicalNote($biographicalNote = null)
    {
        // validation for constraint: string
        if (!is_null($biographicalNote) && !is_string($biographicalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($biographicalNote, true), gettype($biographicalNote)), __LINE__);
        }
        $this->biographicalNote = $biographicalNote;
        return $this;
    }
}
