<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for catalog EnumType
 * @subpackage Enumerations
 */
class Catalog extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PNB'
     * @return string 'PNB'
     */
    const VALUE_PNB = 'PNB';
    /**
     * Constant for value 'MAT'
     * @return string 'MAT'
     */
    const VALUE_MAT = 'MAT';
    /**
     * Constant for value 'HUB'
     * @return string 'HUB'
     */
    const VALUE_HUB = 'HUB';
    /**
     * Return allowed values
     * @uses self::VALUE_PNB
     * @uses self::VALUE_MAT
     * @uses self::VALUE_HUB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PNB,
            self::VALUE_MAT,
            self::VALUE_HUB,
        );
    }
}
