<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebSearchRequest StructType
 * @subpackage Structs
 */
class WebSearchRequest extends AbstractStructBase
{
    /**
     * The login
     * @var string
     */
    public $login;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The pagination
     * @var \StructType\Pagination
     */
    public $pagination;
    /**
     * The catalog
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - ref: hns:catalog
     * @var string[]
     */
    public $catalog;
    /**
     * The selection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:selection
     * @var string
     */
    public $selection;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:category
     * @var string
     */
    public $category;
    /**
     * The public
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: hns:public
     * @var string[]
     */
    public $public;
    /**
     * The availabilityFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $availabilityFilter;
    /**
     * The quickSearch
     * Meta information extracted from the WSDL
     * - choice: quickSearch | advancedSearch
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $quickSearch;
    /**
     * The advancedSearch
     * Meta information extracted from the WSDL
     * - choice: quickSearch | advancedSearch
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\AdvancedSearch
     */
    public $advancedSearch;
    /**
     * Constructor method for WebSearchRequest
     * @uses WebSearchRequest::setLogin()
     * @uses WebSearchRequest::setPassword()
     * @uses WebSearchRequest::setPagination()
     * @uses WebSearchRequest::setCatalog()
     * @uses WebSearchRequest::setSelection()
     * @uses WebSearchRequest::setCategory()
     * @uses WebSearchRequest::setPublic()
     * @uses WebSearchRequest::setAvailabilityFilter()
     * @uses WebSearchRequest::setQuickSearch()
     * @uses WebSearchRequest::setAdvancedSearch()
     * @param string $login
     * @param string $password
     * @param \StructType\Pagination $pagination
     * @param string[] $catalog
     * @param string $selection
     * @param string $category
     * @param string[] $public
     * @param string $availabilityFilter
     * @param string $quickSearch
     * @param \StructType\AdvancedSearch $advancedSearch
     */
    public function __construct($login = null, $password = null, \StructType\Pagination $pagination = null, array $catalog = array(), $selection = null, $category = null, array $public = array(), $availabilityFilter = null, $quickSearch = null, \StructType\AdvancedSearch $advancedSearch = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setPagination($pagination)
            ->setCatalog($catalog)
            ->setSelection($selection)
            ->setCategory($category)
            ->setPublic($public)
            ->setAvailabilityFilter($availabilityFilter)
            ->setQuickSearch($quickSearch)
            ->setAdvancedSearch($advancedSearch);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\WebSearchRequest
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\WebSearchRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pagination value
     * @return \StructType\Pagination|null
     */
    public function getPagination()
    {
        return $this->pagination;
    }
    /**
     * Set pagination value
     * @param \StructType\Pagination $pagination
     * @return \StructType\WebSearchRequest
     */
    public function setPagination(\StructType\Pagination $pagination = null)
    {
        $this->pagination = $pagination;
        return $this;
    }
    /**
     * Get catalog value
     * @return string[]|null
     */
    public function getCatalog()
    {
        return $this->catalog;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalogForArrayConstraintsFromSetCatalog(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $webSearchRequestCatalogItem) {
            // validation for constraint: enumeration
            if (!\EnumType\Catalog::valueIsValid($webSearchRequestCatalogItem)) {
                $invalidValues[] = is_object($webSearchRequestCatalogItem) ? get_class($webSearchRequestCatalogItem) : sprintf('%s(%s)', gettype($webSearchRequestCatalogItem), var_export($webSearchRequestCatalogItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Catalog', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\Catalog::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set catalog value
     * @uses \EnumType\Catalog::valueIsValid()
     * @uses \EnumType\Catalog::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $catalog
     * @return \StructType\WebSearchRequest
     */
    public function setCatalog(array $catalog = array())
    {
        // validation for constraint: array
        if ('' !== ($catalogArrayErrorMessage = self::validateCatalogForArrayConstraintsFromSetCatalog($catalog))) {
            throw new \InvalidArgumentException($catalogArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($catalog) && count($catalog) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($catalog)), __LINE__);
        }
        $this->catalog = $catalog;
        return $this;
    }
    /**
     * Add item to catalog value
     * @uses \EnumType\Catalog::valueIsValid()
     * @uses \EnumType\Catalog::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\WebSearchRequest
     */
    public function addToCatalog($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Catalog::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Catalog', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\Catalog::getValidValues())), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->catalog) && count($this->catalog) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->catalog)), __LINE__);
        }
        $this->catalog[] = $item;
        return $this;
    }
    /**
     * Get selection value
     * @return string|null
     */
    public function getSelection()
    {
        return $this->selection;
    }
    /**
     * Set selection value
     * @param string $selection
     * @return \StructType\WebSearchRequest
     */
    public function setSelection($selection = null)
    {
        // validation for constraint: string
        if (!is_null($selection) && !is_string($selection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selection, true), gettype($selection)), __LINE__);
        }
        $this->selection = $selection;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\WebSearchRequest
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get public value
     * @return string[]|null
     */
    public function getPublic()
    {
        return $this->public;
    }
    /**
     * This method is responsible for validating the values passed to the setPublic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPublic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePublicForArrayConstraintsFromSetPublic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $webSearchRequestPublicItem) {
            // validation for constraint: itemType
            if (!is_string($webSearchRequestPublicItem)) {
                $invalidValues[] = is_object($webSearchRequestPublicItem) ? get_class($webSearchRequestPublicItem) : sprintf('%s(%s)', gettype($webSearchRequestPublicItem), var_export($webSearchRequestPublicItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The public property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set public value
     * @throws \InvalidArgumentException
     * @param string[] $public
     * @return \StructType\WebSearchRequest
     */
    public function setPublic(array $public = array())
    {
        // validation for constraint: array
        if ('' !== ($publicArrayErrorMessage = self::validatePublicForArrayConstraintsFromSetPublic($public))) {
            throw new \InvalidArgumentException($publicArrayErrorMessage, __LINE__);
        }
        $this->public = $public;
        return $this;
    }
    /**
     * Add item to public value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\WebSearchRequest
     */
    public function addToPublic($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The public property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->public[] = $item;
        return $this;
    }
    /**
     * Get availabilityFilter value
     * @return string|null
     */
    public function getAvailabilityFilter()
    {
        return $this->availabilityFilter;
    }
    /**
     * Set availabilityFilter value
     * @uses \EnumType\AvailabilityFilter::valueIsValid()
     * @uses \EnumType\AvailabilityFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityFilter
     * @return \StructType\WebSearchRequest
     */
    public function setAvailabilityFilter($availabilityFilter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvailabilityFilter::valueIsValid($availabilityFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AvailabilityFilter', is_array($availabilityFilter) ? implode(', ', $availabilityFilter) : var_export($availabilityFilter, true), implode(', ', \EnumType\AvailabilityFilter::getValidValues())), __LINE__);
        }
        $this->availabilityFilter = $availabilityFilter;
        return $this;
    }
    /**
     * Get quickSearch value
     * @return string|null
     */
    public function getQuickSearch()
    {
        return isset($this->quickSearch) ? $this->quickSearch : null;
    }
    /**
     * This method is responsible for validating the value passed to the setQuickSearch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuickSearch method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateQuickSearchForChoiceConstraintsFromSetQuickSearch($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'advancedSearch',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property quickSearch can\'t be set as the property %s is already set. Only one property must be set among these properties: quickSearch, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set quickSearch value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $quickSearch
     * @return \StructType\WebSearchRequest
     */
    public function setQuickSearch($quickSearch = null)
    {
        // validation for constraint: string
        if (!is_null($quickSearch) && !is_string($quickSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quickSearch, true), gettype($quickSearch)), __LINE__);
        }
        // validation for constraint: choice(quickSearch, advancedSearch)
        if ('' !== ($quickSearchChoiceErrorMessage = self::validateQuickSearchForChoiceConstraintsFromSetQuickSearch($quickSearch))) {
            throw new \InvalidArgumentException($quickSearchChoiceErrorMessage, __LINE__);
        }
        if (is_null($quickSearch) || (is_array($quickSearch) && empty($quickSearch))) {
            unset($this->quickSearch);
        } else {
            $this->quickSearch = $quickSearch;
        }
        return $this;
    }
    /**
     * Get advancedSearch value
     * @return \StructType\AdvancedSearch|null
     */
    public function getAdvancedSearch()
    {
        return isset($this->advancedSearch) ? $this->advancedSearch : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAdvancedSearch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdvancedSearch method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAdvancedSearchForChoiceConstraintsFromSetAdvancedSearch($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'quickSearch',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property advancedSearch can\'t be set as the property %s is already set. Only one property must be set among these properties: advancedSearch, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set advancedSearch value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AdvancedSearch $advancedSearch
     * @return \StructType\WebSearchRequest
     */
    public function setAdvancedSearch(\StructType\AdvancedSearch $advancedSearch = null)
    {
        // validation for constraint: choice(quickSearch, advancedSearch)
        if ('' !== ($advancedSearchChoiceErrorMessage = self::validateAdvancedSearchForChoiceConstraintsFromSetAdvancedSearch($advancedSearch))) {
            throw new \InvalidArgumentException($advancedSearchChoiceErrorMessage, __LINE__);
        }
        if (is_null($advancedSearch) || (is_array($advancedSearch) && empty($advancedSearch))) {
            unset($this->advancedSearch);
        } else {
            $this->advancedSearch = $advancedSearch;
        }
        return $this;
    }
}
