<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for supplier StructType
 * @subpackage Structs
 */
class Supplier extends AbstractStructBase
{
    /**
     * The supplierName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:supplierName
     * @var string
     */
    public $supplierName;
    /**
     * The supplierGln
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9]{13}
     * - ref: hns:supplierGln
     * @var string
     */
    public $supplierGln;
    /**
     * Constructor method for supplier
     * @uses Supplier::setSupplierName()
     * @uses Supplier::setSupplierGln()
     * @param string $supplierName
     * @param string $supplierGln
     */
    public function __construct($supplierName = null, $supplierGln = null)
    {
        $this
            ->setSupplierName($supplierName)
            ->setSupplierGln($supplierGln);
    }
    /**
     * Get supplierName value
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->supplierName;
    }
    /**
     * Set supplierName value
     * @param string $supplierName
     * @return \StructType\Supplier
     */
    public function setSupplierName($supplierName = null)
    {
        // validation for constraint: string
        if (!is_null($supplierName) && !is_string($supplierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierName, true), gettype($supplierName)), __LINE__);
        }
        $this->supplierName = $supplierName;
        return $this;
    }
    /**
     * Get supplierGln value
     * @return string|null
     */
    public function getSupplierGln()
    {
        return $this->supplierGln;
    }
    /**
     * Set supplierGln value
     * @param string $supplierGln
     * @return \StructType\Supplier
     */
    public function setSupplierGln($supplierGln = null)
    {
        // validation for constraint: string
        if (!is_null($supplierGln) && !is_string($supplierGln)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierGln, true), gettype($supplierGln)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{13})
        if (!is_null($supplierGln) && !preg_match('/[0-9]{13}/', $supplierGln)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{13}', var_export($supplierGln, true)), __LINE__);
        }
        $this->supplierGln = $supplierGln;
        return $this;
    }
}
