<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for supportingResource StructType
 * @subpackage Structs
 */
class SupportingResource extends AbstractStructBase
{
    /**
     * The picture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:picture
     * @var \StructType\Picture
     */
    public $picture;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:description
     * @var string
     */
    public $description;
    /**
     * The tableOfContents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:tableOfContents
     * @var string
     */
    public $tableOfContents;
    /**
     * The excerpt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:excerpt
     * @var string
     */
    public $excerpt;
    /**
     * The lookInside
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:lookInside
     * @var string
     */
    public $lookInside;
    /**
     * The literaryPrize
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * - ref: hns:literaryPrize
     * @var \StructType\LiteraryPrize[]
     */
    public $literaryPrize;
    /**
     * Constructor method for supportingResource
     * @uses SupportingResource::setPicture()
     * @uses SupportingResource::setDescription()
     * @uses SupportingResource::setTableOfContents()
     * @uses SupportingResource::setExcerpt()
     * @uses SupportingResource::setLookInside()
     * @uses SupportingResource::setLiteraryPrize()
     * @param \StructType\Picture $picture
     * @param string $description
     * @param string $tableOfContents
     * @param string $excerpt
     * @param string $lookInside
     * @param \StructType\LiteraryPrize[] $literaryPrize
     */
    public function __construct(\StructType\Picture $picture = null, $description = null, $tableOfContents = null, $excerpt = null, $lookInside = null, array $literaryPrize = array())
    {
        $this
            ->setPicture($picture)
            ->setDescription($description)
            ->setTableOfContents($tableOfContents)
            ->setExcerpt($excerpt)
            ->setLookInside($lookInside)
            ->setLiteraryPrize($literaryPrize);
    }
    /**
     * Get picture value
     * @return \StructType\Picture|null
     */
    public function getPicture()
    {
        return $this->picture;
    }
    /**
     * Set picture value
     * @param \StructType\Picture $picture
     * @return \StructType\SupportingResource
     */
    public function setPicture(\StructType\Picture $picture = null)
    {
        $this->picture = $picture;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SupportingResource
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get tableOfContents value
     * @return string|null
     */
    public function getTableOfContents()
    {
        return $this->tableOfContents;
    }
    /**
     * Set tableOfContents value
     * @param string $tableOfContents
     * @return \StructType\SupportingResource
     */
    public function setTableOfContents($tableOfContents = null)
    {
        // validation for constraint: string
        if (!is_null($tableOfContents) && !is_string($tableOfContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tableOfContents, true), gettype($tableOfContents)), __LINE__);
        }
        $this->tableOfContents = $tableOfContents;
        return $this;
    }
    /**
     * Get excerpt value
     * @return string|null
     */
    public function getExcerpt()
    {
        return $this->excerpt;
    }
    /**
     * Set excerpt value
     * @param string $excerpt
     * @return \StructType\SupportingResource
     */
    public function setExcerpt($excerpt = null)
    {
        // validation for constraint: string
        if (!is_null($excerpt) && !is_string($excerpt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($excerpt, true), gettype($excerpt)), __LINE__);
        }
        $this->excerpt = $excerpt;
        return $this;
    }
    /**
     * Get lookInside value
     * @return string|null
     */
    public function getLookInside()
    {
        return $this->lookInside;
    }
    /**
     * Set lookInside value
     * @param string $lookInside
     * @return \StructType\SupportingResource
     */
    public function setLookInside($lookInside = null)
    {
        // validation for constraint: string
        if (!is_null($lookInside) && !is_string($lookInside)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lookInside, true), gettype($lookInside)), __LINE__);
        }
        $this->lookInside = $lookInside;
        return $this;
    }
    /**
     * Get literaryPrize value
     * @return \StructType\LiteraryPrize[]|null
     */
    public function getLiteraryPrize()
    {
        return $this->literaryPrize;
    }
    /**
     * This method is responsible for validating the values passed to the setLiteraryPrize method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLiteraryPrize method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLiteraryPrizeForArrayConstraintsFromSetLiteraryPrize(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supportingResourceLiteraryPrizeItem) {
            // validation for constraint: itemType
            if (!$supportingResourceLiteraryPrizeItem instanceof \StructType\LiteraryPrize) {
                $invalidValues[] = is_object($supportingResourceLiteraryPrizeItem) ? get_class($supportingResourceLiteraryPrizeItem) : sprintf('%s(%s)', gettype($supportingResourceLiteraryPrizeItem), var_export($supportingResourceLiteraryPrizeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The literaryPrize property can only contain items of type \StructType\LiteraryPrize, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set literaryPrize value
     * @throws \InvalidArgumentException
     * @param \StructType\LiteraryPrize[] $literaryPrize
     * @return \StructType\SupportingResource
     */
    public function setLiteraryPrize(array $literaryPrize = array())
    {
        // validation for constraint: array
        if ('' !== ($literaryPrizeArrayErrorMessage = self::validateLiteraryPrizeForArrayConstraintsFromSetLiteraryPrize($literaryPrize))) {
            throw new \InvalidArgumentException($literaryPrizeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($literaryPrize) && count($literaryPrize) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($literaryPrize)), __LINE__);
        }
        $this->literaryPrize = $literaryPrize;
        return $this;
    }
    /**
     * Add item to literaryPrize value
     * @throws \InvalidArgumentException
     * @param \StructType\LiteraryPrize $item
     * @return \StructType\SupportingResource
     */
    public function addToLiteraryPrize(\StructType\LiteraryPrize $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LiteraryPrize) {
            throw new \InvalidArgumentException(sprintf('The literaryPrize property can only contain items of type \StructType\LiteraryPrize, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->literaryPrize) && count($this->literaryPrize) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->literaryPrize)), __LINE__);
        }
        $this->literaryPrize[] = $item;
        return $this;
    }
}
