<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for simpleSubject StructType
 * @subpackage Structs
 */
class SimpleSubject extends AbstractStructBase
{
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $category;
    /**
     * The public
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $public;
    /**
     * Constructor method for simpleSubject
     * @uses SimpleSubject::setCategory()
     * @uses SimpleSubject::setPublic()
     * @param string $category
     * @param string $public
     */
    public function __construct($category = null, $public = null)
    {
        $this
            ->setCategory($category)
            ->setPublic($public);
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\SimpleSubject
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get public value
     * @return string|null
     */
    public function getPublic()
    {
        return $this->public;
    }
    /**
     * Set public value
     * @param string $public
     * @return \StructType\SimpleSubject
     */
    public function setPublic($public = null)
    {
        // validation for constraint: string
        if (!is_null($public) && !is_string($public)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($public, true), gettype($public)), __LINE__);
        }
        $this->public = $public;
        return $this;
    }
}
