<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for simpleContributor StructType
 * @subpackage Structs
 */
class SimpleContributor extends AbstractStructBase
{
    /**
     * The contributorRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contributorRole;
    /**
     * The keyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $keyName;
    /**
     * The nameBeforeKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nameBeforeKey;
    /**
     * Constructor method for simpleContributor
     * @uses SimpleContributor::setContributorRole()
     * @uses SimpleContributor::setKeyName()
     * @uses SimpleContributor::setNameBeforeKey()
     * @param string $contributorRole
     * @param string $keyName
     * @param string $nameBeforeKey
     */
    public function __construct($contributorRole = null, $keyName = null, $nameBeforeKey = null)
    {
        $this
            ->setContributorRole($contributorRole)
            ->setKeyName($keyName)
            ->setNameBeforeKey($nameBeforeKey);
    }
    /**
     * Get contributorRole value
     * @return string|null
     */
    public function getContributorRole()
    {
        return $this->contributorRole;
    }
    /**
     * Set contributorRole value
     * @param string $contributorRole
     * @return \StructType\SimpleContributor
     */
    public function setContributorRole($contributorRole = null)
    {
        // validation for constraint: string
        if (!is_null($contributorRole) && !is_string($contributorRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contributorRole, true), gettype($contributorRole)), __LINE__);
        }
        $this->contributorRole = $contributorRole;
        return $this;
    }
    /**
     * Get keyName value
     * @return string|null
     */
    public function getKeyName()
    {
        return $this->keyName;
    }
    /**
     * Set keyName value
     * @param string $keyName
     * @return \StructType\SimpleContributor
     */
    public function setKeyName($keyName = null)
    {
        // validation for constraint: string
        if (!is_null($keyName) && !is_string($keyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyName, true), gettype($keyName)), __LINE__);
        }
        $this->keyName = $keyName;
        return $this;
    }
    /**
     * Get nameBeforeKey value
     * @return string|null
     */
    public function getNameBeforeKey()
    {
        return $this->nameBeforeKey;
    }
    /**
     * Set nameBeforeKey value
     * @param string $nameBeforeKey
     * @return \StructType\SimpleContributor
     */
    public function setNameBeforeKey($nameBeforeKey = null)
    {
        // validation for constraint: string
        if (!is_null($nameBeforeKey) && !is_string($nameBeforeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameBeforeKey, true), gettype($nameBeforeKey)), __LINE__);
        }
        $this->nameBeforeKey = $nameBeforeKey;
        return $this;
    }
}
