<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedProduct StructType
 * @subpackage Structs
 */
class RelatedProduct extends AbstractStructBase
{
    /**
     * The HUB
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: hns:HUB
     * @var \StructType\HUB[]
     */
    public $HUB;
    /**
     * The PNB
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: hns:PNB
     * @var \StructType\PNB[]
     */
    public $PNB;
    /**
     * The MAT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: hns:MAT
     * @var \StructType\MAT[]
     */
    public $MAT;
    /**
     * Constructor method for relatedProduct
     * @uses RelatedProduct::setHUB()
     * @uses RelatedProduct::setPNB()
     * @uses RelatedProduct::setMAT()
     * @param \StructType\HUB[] $hUB
     * @param \StructType\PNB[] $pNB
     * @param \StructType\MAT[] $mAT
     */
    public function __construct(array $hUB = array(), array $pNB = array(), array $mAT = array())
    {
        $this
            ->setHUB($hUB)
            ->setPNB($pNB)
            ->setMAT($mAT);
    }
    /**
     * Get HUB value
     * @return \StructType\HUB[]|null
     */
    public function getHUB()
    {
        return $this->HUB;
    }
    /**
     * This method is responsible for validating the values passed to the setHUB method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHUB method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHUBForArrayConstraintsFromSetHUB(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedProductHUBItem) {
            // validation for constraint: itemType
            if (!$relatedProductHUBItem instanceof \StructType\HUB) {
                $invalidValues[] = is_object($relatedProductHUBItem) ? get_class($relatedProductHUBItem) : sprintf('%s(%s)', gettype($relatedProductHUBItem), var_export($relatedProductHUBItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HUB property can only contain items of type \StructType\HUB, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HUB value
     * @throws \InvalidArgumentException
     * @param \StructType\HUB[] $hUB
     * @return \StructType\RelatedProduct
     */
    public function setHUB(array $hUB = array())
    {
        // validation for constraint: array
        if ('' !== ($hUBArrayErrorMessage = self::validateHUBForArrayConstraintsFromSetHUB($hUB))) {
            throw new \InvalidArgumentException($hUBArrayErrorMessage, __LINE__);
        }
        $this->HUB = $hUB;
        return $this;
    }
    /**
     * Add item to HUB value
     * @throws \InvalidArgumentException
     * @param \StructType\HUB $item
     * @return \StructType\RelatedProduct
     */
    public function addToHUB(\StructType\HUB $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HUB) {
            throw new \InvalidArgumentException(sprintf('The HUB property can only contain items of type \StructType\HUB, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HUB[] = $item;
        return $this;
    }
    /**
     * Get PNB value
     * @return \StructType\PNB[]|null
     */
    public function getPNB()
    {
        return $this->PNB;
    }
    /**
     * This method is responsible for validating the values passed to the setPNB method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPNB method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePNBForArrayConstraintsFromSetPNB(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedProductPNBItem) {
            // validation for constraint: itemType
            if (!$relatedProductPNBItem instanceof \StructType\PNB) {
                $invalidValues[] = is_object($relatedProductPNBItem) ? get_class($relatedProductPNBItem) : sprintf('%s(%s)', gettype($relatedProductPNBItem), var_export($relatedProductPNBItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PNB property can only contain items of type \StructType\PNB, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PNB value
     * @throws \InvalidArgumentException
     * @param \StructType\PNB[] $pNB
     * @return \StructType\RelatedProduct
     */
    public function setPNB(array $pNB = array())
    {
        // validation for constraint: array
        if ('' !== ($pNBArrayErrorMessage = self::validatePNBForArrayConstraintsFromSetPNB($pNB))) {
            throw new \InvalidArgumentException($pNBArrayErrorMessage, __LINE__);
        }
        $this->PNB = $pNB;
        return $this;
    }
    /**
     * Add item to PNB value
     * @throws \InvalidArgumentException
     * @param \StructType\PNB $item
     * @return \StructType\RelatedProduct
     */
    public function addToPNB(\StructType\PNB $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PNB) {
            throw new \InvalidArgumentException(sprintf('The PNB property can only contain items of type \StructType\PNB, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PNB[] = $item;
        return $this;
    }
    /**
     * Get MAT value
     * @return \StructType\MAT[]|null
     */
    public function getMAT()
    {
        return $this->MAT;
    }
    /**
     * This method is responsible for validating the values passed to the setMAT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMAT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMATForArrayConstraintsFromSetMAT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedProductMATItem) {
            // validation for constraint: itemType
            if (!$relatedProductMATItem instanceof \StructType\MAT) {
                $invalidValues[] = is_object($relatedProductMATItem) ? get_class($relatedProductMATItem) : sprintf('%s(%s)', gettype($relatedProductMATItem), var_export($relatedProductMATItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MAT property can only contain items of type \StructType\MAT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MAT value
     * @throws \InvalidArgumentException
     * @param \StructType\MAT[] $mAT
     * @return \StructType\RelatedProduct
     */
    public function setMAT(array $mAT = array())
    {
        // validation for constraint: array
        if ('' !== ($mATArrayErrorMessage = self::validateMATForArrayConstraintsFromSetMAT($mAT))) {
            throw new \InvalidArgumentException($mATArrayErrorMessage, __LINE__);
        }
        $this->MAT = $mAT;
        return $this;
    }
    /**
     * Add item to MAT value
     * @throws \InvalidArgumentException
     * @param \StructType\MAT $item
     * @return \StructType\RelatedProduct
     */
    public function addToMAT(\StructType\MAT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MAT) {
            throw new \InvalidArgumentException(sprintf('The MAT property can only contain items of type \StructType\MAT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MAT[] = $item;
        return $this;
    }
}
