<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for literaryPrize StructType
 * @subpackage Structs
 */
class LiteraryPrize extends AbstractStructBase
{
    /**
     * The prizeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:prizeName
     * @var string
     */
    public $prizeName;
    /**
     * The prizeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:prizeDate
     * @var string
     */
    public $prizeDate;
    /**
     * Constructor method for literaryPrize
     * @uses LiteraryPrize::setPrizeName()
     * @uses LiteraryPrize::setPrizeDate()
     * @param string $prizeName
     * @param string $prizeDate
     */
    public function __construct($prizeName = null, $prizeDate = null)
    {
        $this
            ->setPrizeName($prizeName)
            ->setPrizeDate($prizeDate);
    }
    /**
     * Get prizeName value
     * @return string|null
     */
    public function getPrizeName()
    {
        return $this->prizeName;
    }
    /**
     * Set prizeName value
     * @param string $prizeName
     * @return \StructType\LiteraryPrize
     */
    public function setPrizeName($prizeName = null)
    {
        // validation for constraint: string
        if (!is_null($prizeName) && !is_string($prizeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prizeName, true), gettype($prizeName)), __LINE__);
        }
        $this->prizeName = $prizeName;
        return $this;
    }
    /**
     * Get prizeDate value
     * @return string|null
     */
    public function getPrizeDate()
    {
        return $this->prizeDate;
    }
    /**
     * Set prizeDate value
     * @param string $prizeDate
     * @return \StructType\LiteraryPrize
     */
    public function setPrizeDate($prizeDate = null)
    {
        // validation for constraint: string
        if (!is_null($prizeDate) && !is_string($prizeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prizeDate, true), gettype($prizeDate)), __LINE__);
        }
        $this->prizeDate = $prizeDate;
        return $this;
    }
}
