<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for categoryList StructType
 * @subpackage Structs
 */
class CategoryList extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: hns:Name
     * @var \StructType\Name[]
     */
    public $Name;
    /**
     * Constructor method for categoryList
     * @uses CategoryList::setName()
     * @param \StructType\Name[] $name
     */
    public function __construct(array $name = array())
    {
        $this
            ->setName($name);
    }
    /**
     * Get Name value
     * @return \StructType\Name[]|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryListNameItem) {
            // validation for constraint: itemType
            if (!$categoryListNameItem instanceof \StructType\Name) {
                $invalidValues[] = is_object($categoryListNameItem) ? get_class($categoryListNameItem) : sprintf('%s(%s)', gettype($categoryListNameItem), var_export($categoryListNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Name property can only contain items of type \StructType\Name, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Name value
     * @throws \InvalidArgumentException
     * @param \StructType\Name[] $name
     * @return \StructType\CategoryList
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Add item to Name value
     * @throws \InvalidArgumentException
     * @param \StructType\Name $item
     * @return \StructType\CategoryList
     */
    public function addToName(\StructType\Name $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Name) {
            throw new \InvalidArgumentException(sprintf('The Name property can only contain items of type \StructType\Name, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Name[] = $item;
        return $this;
    }
}
