<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Web ServiceType
 * @subpackage Services
 */
class Web extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WebSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WebSearchRequest $webSearchRequest
     * @return \StructType\WebSearchResponse|bool
     */
    public function WebSearch(\StructType\WebSearchRequest $webSearchRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->WebSearch($webSearchRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WebSearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
