<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for supplyDetail StructType
 * @subpackage Structs
 */
class SupplyDetail extends AbstractStructBase
{
    /**
     * The supplier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:supplier
     * @var \StructType\Supplier
     */
    public $supplier;
    /**
     * The productAvailability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:productAvailability
     * @var string
     */
    public $productAvailability;
    /**
     * The printOnDemand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:printOnDemand
     * @var string
     */
    public $printOnDemand;
    /**
     * The publicationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:publicationDate
     * @var string
     */
    public $publicationDate;
    /**
     * The endMarketDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:endMarketDate
     * @var string
     */
    public $endMarketDate;
    /**
     * The order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:order
     * @var string
     */
    public $order;
    /**
     * The returns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:returns
     * @var string
     */
    public $returns;
    /**
     * The lastDateReturns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:lastDateReturns
     * @var string
     */
    public $lastDateReturns;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:price
     * @var \StructType\Price
     */
    public $price;
    /**
     * The futurePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:futurePrice
     * @var \StructType\FuturePrice
     */
    public $futurePrice;
    /**
     * The unpriced
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:unpriced
     * @var string
     */
    public $unpriced;
    /**
     * Constructor method for supplyDetail
     * @uses SupplyDetail::setSupplier()
     * @uses SupplyDetail::setProductAvailability()
     * @uses SupplyDetail::setPrintOnDemand()
     * @uses SupplyDetail::setPublicationDate()
     * @uses SupplyDetail::setEndMarketDate()
     * @uses SupplyDetail::setOrder()
     * @uses SupplyDetail::setReturns()
     * @uses SupplyDetail::setLastDateReturns()
     * @uses SupplyDetail::setPrice()
     * @uses SupplyDetail::setFuturePrice()
     * @uses SupplyDetail::setUnpriced()
     * @param \StructType\Supplier $supplier
     * @param string $productAvailability
     * @param string $printOnDemand
     * @param string $publicationDate
     * @param string $endMarketDate
     * @param string $order
     * @param string $returns
     * @param string $lastDateReturns
     * @param \StructType\Price $price
     * @param \StructType\FuturePrice $futurePrice
     * @param string $unpriced
     */
    public function __construct(\StructType\Supplier $supplier = null, $productAvailability = null, $printOnDemand = null, $publicationDate = null, $endMarketDate = null, $order = null, $returns = null, $lastDateReturns = null, \StructType\Price $price = null, \StructType\FuturePrice $futurePrice = null, $unpriced = null)
    {
        $this
            ->setSupplier($supplier)
            ->setProductAvailability($productAvailability)
            ->setPrintOnDemand($printOnDemand)
            ->setPublicationDate($publicationDate)
            ->setEndMarketDate($endMarketDate)
            ->setOrder($order)
            ->setReturns($returns)
            ->setLastDateReturns($lastDateReturns)
            ->setPrice($price)
            ->setFuturePrice($futurePrice)
            ->setUnpriced($unpriced);
    }
    /**
     * Get supplier value
     * @return \StructType\Supplier|null
     */
    public function getSupplier()
    {
        return $this->supplier;
    }
    /**
     * Set supplier value
     * @param \StructType\Supplier $supplier
     * @return \StructType\SupplyDetail
     */
    public function setSupplier(\StructType\Supplier $supplier = null)
    {
        $this->supplier = $supplier;
        return $this;
    }
    /**
     * Get productAvailability value
     * @return string|null
     */
    public function getProductAvailability()
    {
        return $this->productAvailability;
    }
    /**
     * Set productAvailability value
     * @param string $productAvailability
     * @return \StructType\SupplyDetail
     */
    public function setProductAvailability($productAvailability = null)
    {
        // validation for constraint: string
        if (!is_null($productAvailability) && !is_string($productAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productAvailability, true), gettype($productAvailability)), __LINE__);
        }
        $this->productAvailability = $productAvailability;
        return $this;
    }
    /**
     * Get printOnDemand value
     * @return string|null
     */
    public function getPrintOnDemand()
    {
        return $this->printOnDemand;
    }
    /**
     * Set printOnDemand value
     * @param string $printOnDemand
     * @return \StructType\SupplyDetail
     */
    public function setPrintOnDemand($printOnDemand = null)
    {
        // validation for constraint: string
        if (!is_null($printOnDemand) && !is_string($printOnDemand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printOnDemand, true), gettype($printOnDemand)), __LINE__);
        }
        $this->printOnDemand = $printOnDemand;
        return $this;
    }
    /**
     * Get publicationDate value
     * @return string|null
     */
    public function getPublicationDate()
    {
        return $this->publicationDate;
    }
    /**
     * Set publicationDate value
     * @param string $publicationDate
     * @return \StructType\SupplyDetail
     */
    public function setPublicationDate($publicationDate = null)
    {
        // validation for constraint: string
        if (!is_null($publicationDate) && !is_string($publicationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicationDate, true), gettype($publicationDate)), __LINE__);
        }
        $this->publicationDate = $publicationDate;
        return $this;
    }
    /**
     * Get endMarketDate value
     * @return string|null
     */
    public function getEndMarketDate()
    {
        return $this->endMarketDate;
    }
    /**
     * Set endMarketDate value
     * @param string $endMarketDate
     * @return \StructType\SupplyDetail
     */
    public function setEndMarketDate($endMarketDate = null)
    {
        // validation for constraint: string
        if (!is_null($endMarketDate) && !is_string($endMarketDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endMarketDate, true), gettype($endMarketDate)), __LINE__);
        }
        $this->endMarketDate = $endMarketDate;
        return $this;
    }
    /**
     * Get order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param string $order
     * @return \StructType\SupplyDetail
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get returns value
     * @return string|null
     */
    public function getReturns()
    {
        return $this->returns;
    }
    /**
     * Set returns value
     * @param string $returns
     * @return \StructType\SupplyDetail
     */
    public function setReturns($returns = null)
    {
        // validation for constraint: string
        if (!is_null($returns) && !is_string($returns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returns, true), gettype($returns)), __LINE__);
        }
        $this->returns = $returns;
        return $this;
    }
    /**
     * Get lastDateReturns value
     * @return string|null
     */
    public function getLastDateReturns()
    {
        return $this->lastDateReturns;
    }
    /**
     * Set lastDateReturns value
     * @param string $lastDateReturns
     * @return \StructType\SupplyDetail
     */
    public function setLastDateReturns($lastDateReturns = null)
    {
        // validation for constraint: string
        if (!is_null($lastDateReturns) && !is_string($lastDateReturns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDateReturns, true), gettype($lastDateReturns)), __LINE__);
        }
        $this->lastDateReturns = $lastDateReturns;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\Price|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\Price $price
     * @return \StructType\SupplyDetail
     */
    public function setPrice(\StructType\Price $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get futurePrice value
     * @return \StructType\FuturePrice|null
     */
    public function getFuturePrice()
    {
        return $this->futurePrice;
    }
    /**
     * Set futurePrice value
     * @param \StructType\FuturePrice $futurePrice
     * @return \StructType\SupplyDetail
     */
    public function setFuturePrice(\StructType\FuturePrice $futurePrice = null)
    {
        $this->futurePrice = $futurePrice;
        return $this;
    }
    /**
     * Get unpriced value
     * @return string|null
     */
    public function getUnpriced()
    {
        return $this->unpriced;
    }
    /**
     * Set unpriced value
     * @param string $unpriced
     * @return \StructType\SupplyDetail
     */
    public function setUnpriced($unpriced = null)
    {
        // validation for constraint: string
        if (!is_null($unpriced) && !is_string($unpriced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unpriced, true), gettype($unpriced)), __LINE__);
        }
        $this->unpriced = $unpriced;
        return $this;
    }
}
