<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subject StructType
 * @subpackage Structs
 */
class Subject extends AbstractStructBase
{
    /**
     * The selection
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Selection[]
     */
    public $selection;
    /**
     * The clilSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:clilSubject
     * @var \StructType\ClilSubject
     */
    public $clilSubject;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: hns:language
     * @var string[]
     */
    public $language;
    /**
     * Constructor method for subject
     * @uses Subject::setSelection()
     * @uses Subject::setClilSubject()
     * @uses Subject::setLanguage()
     * @param \StructType\Selection[] $selection
     * @param \StructType\ClilSubject $clilSubject
     * @param string[] $language
     */
    public function __construct(array $selection = array(), \StructType\ClilSubject $clilSubject = null, array $language = array())
    {
        $this
            ->setSelection($selection)
            ->setClilSubject($clilSubject)
            ->setLanguage($language);
    }
    /**
     * Get selection value
     * @return \StructType\Selection[]|null
     */
    public function getSelection()
    {
        return $this->selection;
    }
    /**
     * This method is responsible for validating the values passed to the setSelection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelection method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionForArrayConstraintsFromSetSelection(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subjectSelectionItem) {
            // validation for constraint: itemType
            if (!$subjectSelectionItem instanceof \StructType\Selection) {
                $invalidValues[] = is_object($subjectSelectionItem) ? get_class($subjectSelectionItem) : sprintf('%s(%s)', gettype($subjectSelectionItem), var_export($subjectSelectionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The selection property can only contain items of type \StructType\Selection, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set selection value
     * @throws \InvalidArgumentException
     * @param \StructType\Selection[] $selection
     * @return \StructType\Subject
     */
    public function setSelection(array $selection = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionArrayErrorMessage = self::validateSelectionForArrayConstraintsFromSetSelection($selection))) {
            throw new \InvalidArgumentException($selectionArrayErrorMessage, __LINE__);
        }
        $this->selection = $selection;
        return $this;
    }
    /**
     * Add item to selection value
     * @throws \InvalidArgumentException
     * @param \StructType\Selection $item
     * @return \StructType\Subject
     */
    public function addToSelection(\StructType\Selection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Selection) {
            throw new \InvalidArgumentException(sprintf('The selection property can only contain items of type \StructType\Selection, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->selection[] = $item;
        return $this;
    }
    /**
     * Get clilSubject value
     * @return \StructType\ClilSubject|null
     */
    public function getClilSubject()
    {
        return $this->clilSubject;
    }
    /**
     * Set clilSubject value
     * @param \StructType\ClilSubject $clilSubject
     * @return \StructType\Subject
     */
    public function setClilSubject(\StructType\ClilSubject $clilSubject = null)
    {
        $this->clilSubject = $clilSubject;
        return $this;
    }
    /**
     * Get language value
     * @return string[]|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subjectLanguageItem) {
            // validation for constraint: itemType
            if (!is_string($subjectLanguageItem)) {
                $invalidValues[] = is_object($subjectLanguageItem) ? get_class($subjectLanguageItem) : sprintf('%s(%s)', gettype($subjectLanguageItem), var_export($subjectLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The language property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set language value
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \StructType\Subject
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: array
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Add item to language value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Subject
     */
    public function addToLanguage($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The language property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->language[] = $item;
        return $this;
    }
}
