<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The GTIN13
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9]{13}
     * - ref: hns:GTIN13
     * @var string
     */
    public $GTIN13;
    /**
     * The supplierReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:supplierReference
     * @var string
     */
    public $supplierReference;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:title
     * @var string
     */
    public $title;
    /**
     * The subTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:subTitle
     * @var string
     */
    public $subTitle;
    /**
     * The yearOfAnnual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:yearOfAnnual
     * @var string
     */
    public $yearOfAnnual;
    /**
     * The standardTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:standardTitle
     * @var string
     */
    public $standardTitle;
    /**
     * The receiptTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:receiptTitle
     * @var string
     */
    public $receiptTitle;
    /**
     * The imprintName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:imprintName
     * @var string
     */
    public $imprintName;
    /**
     * The imprintGLN
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9]{13}
     * - ref: hns:imprintGLN
     * @var string
     */
    public $imprintGLN;
    /**
     * The imprintWebsite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:imprintWebsite
     * @var string
     */
    public $imprintWebsite;
    /**
     * The collection
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - ref: hns:collection
     * @var string
     */
    public $collection;
    /**
     * The schoolBook
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:schoolBook
     * @var string
     */
    public $schoolBook;
    /**
     * The BNFControlNumber
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 20
     * - minOccurs: 0
     * - ref: hns:BNFControlNumber
     * @var string
     */
    public $BNFControlNumber;
    /**
     * The origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: hns:origin
     * @var string
     */
    public $origin;
    /**
     * Constructor method for product
     * @uses Product::setGTIN13()
     * @uses Product::setSupplierReference()
     * @uses Product::setTitle()
     * @uses Product::setSubTitle()
     * @uses Product::setYearOfAnnual()
     * @uses Product::setStandardTitle()
     * @uses Product::setReceiptTitle()
     * @uses Product::setImprintName()
     * @uses Product::setImprintGLN()
     * @uses Product::setImprintWebsite()
     * @uses Product::setCollection()
     * @uses Product::setSchoolBook()
     * @uses Product::setBNFControlNumber()
     * @uses Product::setOrigin()
     * @param string $gTIN13
     * @param string $supplierReference
     * @param string $title
     * @param string $subTitle
     * @param string $yearOfAnnual
     * @param string $standardTitle
     * @param string $receiptTitle
     * @param string $imprintName
     * @param string $imprintGLN
     * @param string $imprintWebsite
     * @param string $collection
     * @param string $schoolBook
     * @param string $bNFControlNumber
     * @param string $origin
     */
    public function __construct($gTIN13 = null, $supplierReference = null, $title = null, $subTitle = null, $yearOfAnnual = null, $standardTitle = null, $receiptTitle = null, $imprintName = null, $imprintGLN = null, $imprintWebsite = null, $collection = null, $schoolBook = null, $bNFControlNumber = null, $origin = null)
    {
        $this
            ->setGTIN13($gTIN13)
            ->setSupplierReference($supplierReference)
            ->setTitle($title)
            ->setSubTitle($subTitle)
            ->setYearOfAnnual($yearOfAnnual)
            ->setStandardTitle($standardTitle)
            ->setReceiptTitle($receiptTitle)
            ->setImprintName($imprintName)
            ->setImprintGLN($imprintGLN)
            ->setImprintWebsite($imprintWebsite)
            ->setCollection($collection)
            ->setSchoolBook($schoolBook)
            ->setBNFControlNumber($bNFControlNumber)
            ->setOrigin($origin);
    }
    /**
     * Get GTIN13 value
     * @return string|null
     */
    public function getGTIN13()
    {
        return $this->GTIN13;
    }
    /**
     * Set GTIN13 value
     * @param string $gTIN13
     * @return \StructType\Product
     */
    public function setGTIN13($gTIN13 = null)
    {
        // validation for constraint: string
        if (!is_null($gTIN13) && !is_string($gTIN13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gTIN13, true), gettype($gTIN13)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{13})
        if (!is_null($gTIN13) && !preg_match('/[0-9]{13}/', $gTIN13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{13}', var_export($gTIN13, true)), __LINE__);
        }
        $this->GTIN13 = $gTIN13;
        return $this;
    }
    /**
     * Get supplierReference value
     * @return string|null
     */
    public function getSupplierReference()
    {
        return $this->supplierReference;
    }
    /**
     * Set supplierReference value
     * @param string $supplierReference
     * @return \StructType\Product
     */
    public function setSupplierReference($supplierReference = null)
    {
        // validation for constraint: string
        if (!is_null($supplierReference) && !is_string($supplierReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierReference, true), gettype($supplierReference)), __LINE__);
        }
        $this->supplierReference = $supplierReference;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Product
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get subTitle value
     * @return string|null
     */
    public function getSubTitle()
    {
        return $this->subTitle;
    }
    /**
     * Set subTitle value
     * @param string $subTitle
     * @return \StructType\Product
     */
    public function setSubTitle($subTitle = null)
    {
        // validation for constraint: string
        if (!is_null($subTitle) && !is_string($subTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTitle, true), gettype($subTitle)), __LINE__);
        }
        $this->subTitle = $subTitle;
        return $this;
    }
    /**
     * Get yearOfAnnual value
     * @return string|null
     */
    public function getYearOfAnnual()
    {
        return $this->yearOfAnnual;
    }
    /**
     * Set yearOfAnnual value
     * @param string $yearOfAnnual
     * @return \StructType\Product
     */
    public function setYearOfAnnual($yearOfAnnual = null)
    {
        // validation for constraint: string
        if (!is_null($yearOfAnnual) && !is_string($yearOfAnnual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yearOfAnnual, true), gettype($yearOfAnnual)), __LINE__);
        }
        $this->yearOfAnnual = $yearOfAnnual;
        return $this;
    }
    /**
     * Get standardTitle value
     * @return string|null
     */
    public function getStandardTitle()
    {
        return $this->standardTitle;
    }
    /**
     * Set standardTitle value
     * @param string $standardTitle
     * @return \StructType\Product
     */
    public function setStandardTitle($standardTitle = null)
    {
        // validation for constraint: string
        if (!is_null($standardTitle) && !is_string($standardTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standardTitle, true), gettype($standardTitle)), __LINE__);
        }
        $this->standardTitle = $standardTitle;
        return $this;
    }
    /**
     * Get receiptTitle value
     * @return string|null
     */
    public function getReceiptTitle()
    {
        return $this->receiptTitle;
    }
    /**
     * Set receiptTitle value
     * @param string $receiptTitle
     * @return \StructType\Product
     */
    public function setReceiptTitle($receiptTitle = null)
    {
        // validation for constraint: string
        if (!is_null($receiptTitle) && !is_string($receiptTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptTitle, true), gettype($receiptTitle)), __LINE__);
        }
        $this->receiptTitle = $receiptTitle;
        return $this;
    }
    /**
     * Get imprintName value
     * @return string|null
     */
    public function getImprintName()
    {
        return $this->imprintName;
    }
    /**
     * Set imprintName value
     * @param string $imprintName
     * @return \StructType\Product
     */
    public function setImprintName($imprintName = null)
    {
        // validation for constraint: string
        if (!is_null($imprintName) && !is_string($imprintName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imprintName, true), gettype($imprintName)), __LINE__);
        }
        $this->imprintName = $imprintName;
        return $this;
    }
    /**
     * Get imprintGLN value
     * @return string|null
     */
    public function getImprintGLN()
    {
        return $this->imprintGLN;
    }
    /**
     * Set imprintGLN value
     * @param string $imprintGLN
     * @return \StructType\Product
     */
    public function setImprintGLN($imprintGLN = null)
    {
        // validation for constraint: string
        if (!is_null($imprintGLN) && !is_string($imprintGLN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imprintGLN, true), gettype($imprintGLN)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{13})
        if (!is_null($imprintGLN) && !preg_match('/[0-9]{13}/', $imprintGLN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{13}', var_export($imprintGLN, true)), __LINE__);
        }
        $this->imprintGLN = $imprintGLN;
        return $this;
    }
    /**
     * Get imprintWebsite value
     * @return string|null
     */
    public function getImprintWebsite()
    {
        return $this->imprintWebsite;
    }
    /**
     * Set imprintWebsite value
     * @param string $imprintWebsite
     * @return \StructType\Product
     */
    public function setImprintWebsite($imprintWebsite = null)
    {
        // validation for constraint: string
        if (!is_null($imprintWebsite) && !is_string($imprintWebsite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imprintWebsite, true), gettype($imprintWebsite)), __LINE__);
        }
        $this->imprintWebsite = $imprintWebsite;
        return $this;
    }
    /**
     * Get collection value
     * @return string|null
     */
    public function getCollection()
    {
        return $this->collection;
    }
    /**
     * Set collection value
     * @param string $collection
     * @return \StructType\Product
     */
    public function setCollection($collection = null)
    {
        // validation for constraint: string
        if (!is_null($collection) && !is_string($collection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collection, true), gettype($collection)), __LINE__);
        }
        $this->collection = $collection;
        return $this;
    }
    /**
     * Get schoolBook value
     * @return string|null
     */
    public function getSchoolBook()
    {
        return $this->schoolBook;
    }
    /**
     * Set schoolBook value
     * @param string $schoolBook
     * @return \StructType\Product
     */
    public function setSchoolBook($schoolBook = null)
    {
        // validation for constraint: string
        if (!is_null($schoolBook) && !is_string($schoolBook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schoolBook, true), gettype($schoolBook)), __LINE__);
        }
        $this->schoolBook = $schoolBook;
        return $this;
    }
    /**
     * Get BNFControlNumber value
     * @return string|null
     */
    public function getBNFControlNumber()
    {
        return $this->BNFControlNumber;
    }
    /**
     * Set BNFControlNumber value
     * @param string $bNFControlNumber
     * @return \StructType\Product
     */
    public function setBNFControlNumber($bNFControlNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bNFControlNumber) && !is_string($bNFControlNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bNFControlNumber, true), gettype($bNFControlNumber)), __LINE__);
        }
        // validation for constraint: length(20)
        if (!is_null($bNFControlNumber) && mb_strlen($bNFControlNumber) !== 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 20', mb_strlen($bNFControlNumber)), __LINE__);
        }
        $this->BNFControlNumber = $bNFControlNumber;
        return $this;
    }
    /**
     * Get origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param string $origin
     * @return \StructType\Product
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->origin = $origin;
        return $this;
    }
}
