<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for advancedSearch StructType
 * @subpackage Structs
 */
class AdvancedSearch extends AbstractStructBase
{
    /**
     * The availability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $availability;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The author
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $author;
    /**
     * The publisher
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $publisher;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The distributor
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $distributor;
    /**
     * The GTIN13
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $GTIN13;
    /**
     * The publicationSince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $publicationSince;
    /**
     * The themeClil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ThemeClil
     */
    public $themeClil;
    /**
     * The keywords
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $keywords;
    /**
     * Constructor method for advancedSearch
     * @uses AdvancedSearch::setAvailability()
     * @uses AdvancedSearch::setTitle()
     * @uses AdvancedSearch::setAuthor()
     * @uses AdvancedSearch::setPublisher()
     * @uses AdvancedSearch::setLanguage()
     * @uses AdvancedSearch::setDistributor()
     * @uses AdvancedSearch::setGTIN13()
     * @uses AdvancedSearch::setPublicationSince()
     * @uses AdvancedSearch::setThemeClil()
     * @uses AdvancedSearch::setKeywords()
     * @param string $availability
     * @param string $title
     * @param string $author
     * @param string $publisher
     * @param string $language
     * @param string $distributor
     * @param string $gTIN13
     * @param string $publicationSince
     * @param \StructType\ThemeClil $themeClil
     * @param string $keywords
     */
    public function __construct($availability = null, $title = null, $author = null, $publisher = null, $language = null, $distributor = null, $gTIN13 = null, $publicationSince = null, \StructType\ThemeClil $themeClil = null, $keywords = null)
    {
        $this
            ->setAvailability($availability)
            ->setTitle($title)
            ->setAuthor($author)
            ->setPublisher($publisher)
            ->setLanguage($language)
            ->setDistributor($distributor)
            ->setGTIN13($gTIN13)
            ->setPublicationSince($publicationSince)
            ->setThemeClil($themeClil)
            ->setKeywords($keywords);
    }
    /**
     * Get availability value
     * @return string|null
     */
    public function getAvailability()
    {
        return $this->availability;
    }
    /**
     * Set availability value
     * @uses \EnumType\Availability::valueIsValid()
     * @uses \EnumType\Availability::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availability
     * @return \StructType\AdvancedSearch
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Availability::valueIsValid($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Availability', is_array($availability) ? implode(', ', $availability) : var_export($availability, true), implode(', ', \EnumType\Availability::getValidValues())), __LINE__);
        }
        $this->availability = $availability;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\AdvancedSearch
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($title) && mb_strlen($title) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->author;
    }
    /**
     * Set author value
     * @param string $author
     * @return \StructType\AdvancedSearch
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($author) && mb_strlen($author) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($author)), __LINE__);
        }
        $this->author = $author;
        return $this;
    }
    /**
     * Get publisher value
     * @return string|null
     */
    public function getPublisher()
    {
        return $this->publisher;
    }
    /**
     * Set publisher value
     * @param string $publisher
     * @return \StructType\AdvancedSearch
     */
    public function setPublisher($publisher = null)
    {
        // validation for constraint: string
        if (!is_null($publisher) && !is_string($publisher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publisher, true), gettype($publisher)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($publisher) && mb_strlen($publisher) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($publisher)), __LINE__);
        }
        $this->publisher = $publisher;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\LanguageType::valueIsValid()
     * @uses \EnumType\LanguageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\AdvancedSearch
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguageType::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LanguageType', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\LanguageType::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get distributor value
     * @return string|null
     */
    public function getDistributor()
    {
        return $this->distributor;
    }
    /**
     * Set distributor value
     * @param string $distributor
     * @return \StructType\AdvancedSearch
     */
    public function setDistributor($distributor = null)
    {
        // validation for constraint: string
        if (!is_null($distributor) && !is_string($distributor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributor, true), gettype($distributor)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($distributor) && mb_strlen($distributor) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($distributor)), __LINE__);
        }
        $this->distributor = $distributor;
        return $this;
    }
    /**
     * Get GTIN13 value
     * @return string|null
     */
    public function getGTIN13()
    {
        return $this->GTIN13;
    }
    /**
     * Set GTIN13 value
     * @param string $gTIN13
     * @return \StructType\AdvancedSearch
     */
    public function setGTIN13($gTIN13 = null)
    {
        // validation for constraint: string
        if (!is_null($gTIN13) && !is_string($gTIN13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gTIN13, true), gettype($gTIN13)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($gTIN13) && mb_strlen($gTIN13) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($gTIN13)), __LINE__);
        }
        $this->GTIN13 = $gTIN13;
        return $this;
    }
    /**
     * Get publicationSince value
     * @return string|null
     */
    public function getPublicationSince()
    {
        return $this->publicationSince;
    }
    /**
     * Set publicationSince value
     * @uses \EnumType\PublicationSince::valueIsValid()
     * @uses \EnumType\PublicationSince::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $publicationSince
     * @return \StructType\AdvancedSearch
     */
    public function setPublicationSince($publicationSince = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PublicationSince::valueIsValid($publicationSince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PublicationSince', is_array($publicationSince) ? implode(', ', $publicationSince) : var_export($publicationSince, true), implode(', ', \EnumType\PublicationSince::getValidValues())), __LINE__);
        }
        $this->publicationSince = $publicationSince;
        return $this;
    }
    /**
     * Get themeClil value
     * @return \StructType\ThemeClil|null
     */
    public function getThemeClil()
    {
        return $this->themeClil;
    }
    /**
     * Set themeClil value
     * @param \StructType\ThemeClil $themeClil
     * @return \StructType\AdvancedSearch
     */
    public function setThemeClil(\StructType\ThemeClil $themeClil = null)
    {
        $this->themeClil = $themeClil;
        return $this;
    }
    /**
     * Get keywords value
     * @return string|null
     */
    public function getKeywords()
    {
        return $this->keywords;
    }
    /**
     * Set keywords value
     * @param string $keywords
     * @return \StructType\AdvancedSearch
     */
    public function setKeywords($keywords = null)
    {
        // validation for constraint: string
        if (!is_null($keywords) && !is_string($keywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keywords, true), gettype($keywords)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($keywords) && mb_strlen($keywords) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($keywords)), __LINE__);
        }
        $this->keywords = $keywords;
        return $this;
    }
}
