<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for summaryResult StructType
 * @subpackage Structs
 */
class SummaryResult extends AbstractStructBase
{
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * The totalError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalError;
    /**
     * The totalQueued
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalQueued;
    /**
     * The totalSign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalSign;
    /**
     * Constructor method for summaryResult
     * @uses SummaryResult::setTotal()
     * @uses SummaryResult::setTotalError()
     * @uses SummaryResult::setTotalQueued()
     * @uses SummaryResult::setTotalSign()
     * @param int $total
     * @param int $totalError
     * @param int $totalQueued
     * @param int $totalSign
     */
    public function __construct($total = null, $totalError = null, $totalQueued = null, $totalSign = null)
    {
        $this
            ->setTotal($total)
            ->setTotalError($totalError)
            ->setTotalQueued($totalQueued)
            ->setTotalSign($totalSign);
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\SummaryResult
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get totalError value
     * @return int|null
     */
    public function getTotalError()
    {
        return $this->totalError;
    }
    /**
     * Set totalError value
     * @param int $totalError
     * @return \StructType\SummaryResult
     */
    public function setTotalError($totalError = null)
    {
        // validation for constraint: int
        if (!is_null($totalError) && !(is_int($totalError) || ctype_digit($totalError))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalError, true), gettype($totalError)), __LINE__);
        }
        $this->totalError = $totalError;
        return $this;
    }
    /**
     * Get totalQueued value
     * @return int|null
     */
    public function getTotalQueued()
    {
        return $this->totalQueued;
    }
    /**
     * Set totalQueued value
     * @param int $totalQueued
     * @return \StructType\SummaryResult
     */
    public function setTotalQueued($totalQueued = null)
    {
        // validation for constraint: int
        if (!is_null($totalQueued) && !(is_int($totalQueued) || ctype_digit($totalQueued))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalQueued, true), gettype($totalQueued)), __LINE__);
        }
        $this->totalQueued = $totalQueued;
        return $this;
    }
    /**
     * Get totalSign value
     * @return int|null
     */
    public function getTotalSign()
    {
        return $this->totalSign;
    }
    /**
     * Set totalSign value
     * @param int $totalSign
     * @return \StructType\SummaryResult
     */
    public function setTotalSign($totalSign = null)
    {
        // validation for constraint: int
        if (!is_null($totalSign) && !(is_int($totalSign) || ctype_digit($totalSign))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalSign, true), gettype($totalSign)), __LINE__);
        }
        $this->totalSign = $totalSign;
        return $this;
    }
}
