<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resumen StructType
 * Meta information extracted from the WSDL
 * - type: tns:Resumen
 * @subpackage Structs
 */
class Resumen extends AbstractStructBase
{
    /**
     * The indicador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $indicador;
    /**
     * The tipoDocumentoEmisor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoDocumentoEmisor;
    /**
     * The numeroDocumentoEmisor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroDocumentoEmisor;
    /**
     * The resumenId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resumenId;
    /**
     * The fechaEmisionComprobante
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaEmisionComprobante;
    /**
     * The fechaGeneracionResumen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaGeneracionResumen;
    /**
     * The razonSocialEmisor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $razonSocialEmisor;
    /**
     * The correoEmisor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $correoEmisor;
    /**
     * The resumenTipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resumenTipo;
    /**
     * The inHabilitado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inHabilitado;
    /**
     * The ResumenItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResumenItem[]
     */
    public $ResumenItem;
    /**
     * Constructor method for Resumen
     * @uses Resumen::setIndicador()
     * @uses Resumen::setTipoDocumentoEmisor()
     * @uses Resumen::setNumeroDocumentoEmisor()
     * @uses Resumen::setResumenId()
     * @uses Resumen::setFechaEmisionComprobante()
     * @uses Resumen::setFechaGeneracionResumen()
     * @uses Resumen::setRazonSocialEmisor()
     * @uses Resumen::setCorreoEmisor()
     * @uses Resumen::setResumenTipo()
     * @uses Resumen::setInHabilitado()
     * @uses Resumen::setResumenItem()
     * @param string $indicador
     * @param string $tipoDocumentoEmisor
     * @param string $numeroDocumentoEmisor
     * @param string $resumenId
     * @param string $fechaEmisionComprobante
     * @param string $fechaGeneracionResumen
     * @param string $razonSocialEmisor
     * @param string $correoEmisor
     * @param string $resumenTipo
     * @param string $inHabilitado
     * @param \StructType\ResumenItem[] $resumenItem
     */
    public function __construct($indicador = null, $tipoDocumentoEmisor = null, $numeroDocumentoEmisor = null, $resumenId = null, $fechaEmisionComprobante = null, $fechaGeneracionResumen = null, $razonSocialEmisor = null, $correoEmisor = null, $resumenTipo = null, $inHabilitado = null, array $resumenItem = array())
    {
        $this
            ->setIndicador($indicador)
            ->setTipoDocumentoEmisor($tipoDocumentoEmisor)
            ->setNumeroDocumentoEmisor($numeroDocumentoEmisor)
            ->setResumenId($resumenId)
            ->setFechaEmisionComprobante($fechaEmisionComprobante)
            ->setFechaGeneracionResumen($fechaGeneracionResumen)
            ->setRazonSocialEmisor($razonSocialEmisor)
            ->setCorreoEmisor($correoEmisor)
            ->setResumenTipo($resumenTipo)
            ->setInHabilitado($inHabilitado)
            ->setResumenItem($resumenItem);
    }
    /**
     * Get indicador value
     * @return string|null
     */
    public function getIndicador()
    {
        return $this->indicador;
    }
    /**
     * Set indicador value
     * @param string $indicador
     * @return \StructType\Resumen
     */
    public function setIndicador($indicador = null)
    {
        // validation for constraint: string
        if (!is_null($indicador) && !is_string($indicador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicador, true), gettype($indicador)), __LINE__);
        }
        $this->indicador = $indicador;
        return $this;
    }
    /**
     * Get tipoDocumentoEmisor value
     * @return string|null
     */
    public function getTipoDocumentoEmisor()
    {
        return $this->tipoDocumentoEmisor;
    }
    /**
     * Set tipoDocumentoEmisor value
     * @param string $tipoDocumentoEmisor
     * @return \StructType\Resumen
     */
    public function setTipoDocumentoEmisor($tipoDocumentoEmisor = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumentoEmisor) && !is_string($tipoDocumentoEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumentoEmisor, true), gettype($tipoDocumentoEmisor)), __LINE__);
        }
        $this->tipoDocumentoEmisor = $tipoDocumentoEmisor;
        return $this;
    }
    /**
     * Get numeroDocumentoEmisor value
     * @return string|null
     */
    public function getNumeroDocumentoEmisor()
    {
        return $this->numeroDocumentoEmisor;
    }
    /**
     * Set numeroDocumentoEmisor value
     * @param string $numeroDocumentoEmisor
     * @return \StructType\Resumen
     */
    public function setNumeroDocumentoEmisor($numeroDocumentoEmisor = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDocumentoEmisor) && !is_string($numeroDocumentoEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDocumentoEmisor, true), gettype($numeroDocumentoEmisor)), __LINE__);
        }
        $this->numeroDocumentoEmisor = $numeroDocumentoEmisor;
        return $this;
    }
    /**
     * Get resumenId value
     * @return string|null
     */
    public function getResumenId()
    {
        return $this->resumenId;
    }
    /**
     * Set resumenId value
     * @param string $resumenId
     * @return \StructType\Resumen
     */
    public function setResumenId($resumenId = null)
    {
        // validation for constraint: string
        if (!is_null($resumenId) && !is_string($resumenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resumenId, true), gettype($resumenId)), __LINE__);
        }
        $this->resumenId = $resumenId;
        return $this;
    }
    /**
     * Get fechaEmisionComprobante value
     * @return string|null
     */
    public function getFechaEmisionComprobante()
    {
        return $this->fechaEmisionComprobante;
    }
    /**
     * Set fechaEmisionComprobante value
     * @param string $fechaEmisionComprobante
     * @return \StructType\Resumen
     */
    public function setFechaEmisionComprobante($fechaEmisionComprobante = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmisionComprobante) && !is_string($fechaEmisionComprobante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmisionComprobante, true), gettype($fechaEmisionComprobante)), __LINE__);
        }
        $this->fechaEmisionComprobante = $fechaEmisionComprobante;
        return $this;
    }
    /**
     * Get fechaGeneracionResumen value
     * @return string|null
     */
    public function getFechaGeneracionResumen()
    {
        return $this->fechaGeneracionResumen;
    }
    /**
     * Set fechaGeneracionResumen value
     * @param string $fechaGeneracionResumen
     * @return \StructType\Resumen
     */
    public function setFechaGeneracionResumen($fechaGeneracionResumen = null)
    {
        // validation for constraint: string
        if (!is_null($fechaGeneracionResumen) && !is_string($fechaGeneracionResumen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaGeneracionResumen, true), gettype($fechaGeneracionResumen)), __LINE__);
        }
        $this->fechaGeneracionResumen = $fechaGeneracionResumen;
        return $this;
    }
    /**
     * Get razonSocialEmisor value
     * @return string|null
     */
    public function getRazonSocialEmisor()
    {
        return $this->razonSocialEmisor;
    }
    /**
     * Set razonSocialEmisor value
     * @param string $razonSocialEmisor
     * @return \StructType\Resumen
     */
    public function setRazonSocialEmisor($razonSocialEmisor = null)
    {
        // validation for constraint: string
        if (!is_null($razonSocialEmisor) && !is_string($razonSocialEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($razonSocialEmisor, true), gettype($razonSocialEmisor)), __LINE__);
        }
        $this->razonSocialEmisor = $razonSocialEmisor;
        return $this;
    }
    /**
     * Get correoEmisor value
     * @return string|null
     */
    public function getCorreoEmisor()
    {
        return $this->correoEmisor;
    }
    /**
     * Set correoEmisor value
     * @param string $correoEmisor
     * @return \StructType\Resumen
     */
    public function setCorreoEmisor($correoEmisor = null)
    {
        // validation for constraint: string
        if (!is_null($correoEmisor) && !is_string($correoEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correoEmisor, true), gettype($correoEmisor)), __LINE__);
        }
        $this->correoEmisor = $correoEmisor;
        return $this;
    }
    /**
     * Get resumenTipo value
     * @return string|null
     */
    public function getResumenTipo()
    {
        return $this->resumenTipo;
    }
    /**
     * Set resumenTipo value
     * @param string $resumenTipo
     * @return \StructType\Resumen
     */
    public function setResumenTipo($resumenTipo = null)
    {
        // validation for constraint: string
        if (!is_null($resumenTipo) && !is_string($resumenTipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resumenTipo, true), gettype($resumenTipo)), __LINE__);
        }
        $this->resumenTipo = $resumenTipo;
        return $this;
    }
    /**
     * Get inHabilitado value
     * @return string|null
     */
    public function getInHabilitado()
    {
        return $this->inHabilitado;
    }
    /**
     * Set inHabilitado value
     * @param string $inHabilitado
     * @return \StructType\Resumen
     */
    public function setInHabilitado($inHabilitado = null)
    {
        // validation for constraint: string
        if (!is_null($inHabilitado) && !is_string($inHabilitado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inHabilitado, true), gettype($inHabilitado)), __LINE__);
        }
        $this->inHabilitado = $inHabilitado;
        return $this;
    }
    /**
     * Get ResumenItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResumenItem[]|null
     */
    public function getResumenItem()
    {
        return isset($this->ResumenItem) ? $this->ResumenItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setResumenItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResumenItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResumenItemForArrayConstraintsFromSetResumenItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resumenResumenItemItem) {
            // validation for constraint: itemType
            if (!$resumenResumenItemItem instanceof \StructType\ResumenItem) {
                $invalidValues[] = is_object($resumenResumenItemItem) ? get_class($resumenResumenItemItem) : sprintf('%s(%s)', gettype($resumenResumenItemItem), var_export($resumenResumenItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResumenItem property can only contain items of type \StructType\ResumenItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResumenItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ResumenItem[] $resumenItem
     * @return \StructType\Resumen
     */
    public function setResumenItem(array $resumenItem = array())
    {
        // validation for constraint: array
        if ('' !== ($resumenItemArrayErrorMessage = self::validateResumenItemForArrayConstraintsFromSetResumenItem($resumenItem))) {
            throw new \InvalidArgumentException($resumenItemArrayErrorMessage, __LINE__);
        }
        if (is_null($resumenItem) || (is_array($resumenItem) && empty($resumenItem))) {
            unset($this->ResumenItem);
        } else {
            $this->ResumenItem = $resumenItem;
        }
        return $this;
    }
    /**
     * Add item to ResumenItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ResumenItem $item
     * @return \StructType\Resumen
     */
    public function addToResumenItem(\StructType\ResumenItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResumenItem) {
            throw new \InvalidArgumentException(sprintf('The ResumenItem property can only contain items of type \StructType\ResumenItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ResumenItem[] = $item;
        return $this;
    }
}
