<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for replicateXml StructType
 * Meta information extracted from the WSDL
 * - type: tns:replicateXml
 * @subpackage Structs
 */
class ReplicateXml extends AbstractStructBase
{
    /**
     * The command
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $command;
    /**
     * The xmlSunat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $xmlSunat;
    /**
     * The adjuntos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $adjuntos;
    /**
     * Constructor method for replicateXml
     * @uses ReplicateXml::setCommand()
     * @uses ReplicateXml::setXmlSunat()
     * @uses ReplicateXml::setAdjuntos()
     * @param string $command
     * @param string $xmlSunat
     * @param string $adjuntos
     */
    public function __construct($command = null, $xmlSunat = null, $adjuntos = null)
    {
        $this
            ->setCommand($command)
            ->setXmlSunat($xmlSunat)
            ->setAdjuntos($adjuntos);
    }
    /**
     * Get command value
     * @return string|null
     */
    public function getCommand()
    {
        return $this->command;
    }
    /**
     * Set command value
     * @param string $command
     * @return \StructType\ReplicateXml
     */
    public function setCommand($command = null)
    {
        // validation for constraint: string
        if (!is_null($command) && !is_string($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($command, true), gettype($command)), __LINE__);
        }
        $this->command = $command;
        return $this;
    }
    /**
     * Get xmlSunat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlSunat()
    {
        return isset($this->xmlSunat) ? $this->xmlSunat : null;
    }
    /**
     * Set xmlSunat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlSunat
     * @return \StructType\ReplicateXml
     */
    public function setXmlSunat($xmlSunat = null)
    {
        // validation for constraint: string
        if (!is_null($xmlSunat) && !is_string($xmlSunat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlSunat, true), gettype($xmlSunat)), __LINE__);
        }
        if (is_null($xmlSunat) || (is_array($xmlSunat) && empty($xmlSunat))) {
            unset($this->xmlSunat);
        } else {
            $this->xmlSunat = $xmlSunat;
        }
        return $this;
    }
    /**
     * Get adjuntos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdjuntos()
    {
        return isset($this->adjuntos) ? $this->adjuntos : null;
    }
    /**
     * Set adjuntos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adjuntos
     * @return \StructType\ReplicateXml
     */
    public function setAdjuntos($adjuntos = null)
    {
        // validation for constraint: string
        if (!is_null($adjuntos) && !is_string($adjuntos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adjuntos, true), gettype($adjuntos)), __LINE__);
        }
        if (is_null($adjuntos) || (is_array($adjuntos) && empty($adjuntos))) {
            unset($this->adjuntos);
        } else {
            $this->adjuntos = $adjuntos;
        }
        return $this;
    }
}
