<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item1 StructType
 * @subpackage Structs
 */
class Item1 extends AbstractStructBase
{
    /**
     * The numeroOrdenItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroOrdenItem;
    /**
     * The codigoProducto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoProducto;
    /**
     * The adicionales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Adicionales
     */
    public $adicionales;
    /**
     * Constructor method for Item1
     * @uses Item1::setNumeroOrdenItem()
     * @uses Item1::setCodigoProducto()
     * @uses Item1::setAdicionales()
     * @param string $numeroOrdenItem
     * @param string $codigoProducto
     * @param \StructType\Adicionales $adicionales
     */
    public function __construct($numeroOrdenItem = null, $codigoProducto = null, \StructType\Adicionales $adicionales = null)
    {
        $this
            ->setNumeroOrdenItem($numeroOrdenItem)
            ->setCodigoProducto($codigoProducto)
            ->setAdicionales($adicionales);
    }
    /**
     * Get numeroOrdenItem value
     * @return string|null
     */
    public function getNumeroOrdenItem()
    {
        return $this->numeroOrdenItem;
    }
    /**
     * Set numeroOrdenItem value
     * @param string $numeroOrdenItem
     * @return \StructType\Item1
     */
    public function setNumeroOrdenItem($numeroOrdenItem = null)
    {
        // validation for constraint: string
        if (!is_null($numeroOrdenItem) && !is_string($numeroOrdenItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroOrdenItem, true), gettype($numeroOrdenItem)), __LINE__);
        }
        $this->numeroOrdenItem = $numeroOrdenItem;
        return $this;
    }
    /**
     * Get codigoProducto value
     * @return string|null
     */
    public function getCodigoProducto()
    {
        return $this->codigoProducto;
    }
    /**
     * Set codigoProducto value
     * @param string $codigoProducto
     * @return \StructType\Item1
     */
    public function setCodigoProducto($codigoProducto = null)
    {
        // validation for constraint: string
        if (!is_null($codigoProducto) && !is_string($codigoProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoProducto, true), gettype($codigoProducto)), __LINE__);
        }
        $this->codigoProducto = $codigoProducto;
        return $this;
    }
    /**
     * Get adicionales value
     * @return \StructType\Adicionales|null
     */
    public function getAdicionales()
    {
        return $this->adicionales;
    }
    /**
     * Set adicionales value
     * @param \StructType\Adicionales $adicionales
     * @return \StructType\Item1
     */
    public function setAdicionales(\StructType\Adicionales $adicionales = null)
    {
        $this->adicionales = $adicionales;
        return $this;
    }
}
