<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentoReferencia StructType
 * @subpackage Structs
 */
class DocumentoReferencia extends AbstractStructBase
{
    /**
     * The indicador
     * @var string
     */
    public $indicador;
    /**
     * The tipoDocumentoReferencia
     * @var string
     */
    public $tipoDocumentoReferencia;
    /**
     * The numeroDocumentoReferencia
     * @var string
     */
    public $numeroDocumentoReferencia;
    /**
     * Constructor method for DocumentoReferencia
     * @uses DocumentoReferencia::setIndicador()
     * @uses DocumentoReferencia::setTipoDocumentoReferencia()
     * @uses DocumentoReferencia::setNumeroDocumentoReferencia()
     * @param string $indicador
     * @param string $tipoDocumentoReferencia
     * @param string $numeroDocumentoReferencia
     */
    public function __construct($indicador = null, $tipoDocumentoReferencia = null, $numeroDocumentoReferencia = null)
    {
        $this
            ->setIndicador($indicador)
            ->setTipoDocumentoReferencia($tipoDocumentoReferencia)
            ->setNumeroDocumentoReferencia($numeroDocumentoReferencia);
    }
    /**
     * Get indicador value
     * @return string|null
     */
    public function getIndicador()
    {
        return $this->indicador;
    }
    /**
     * Set indicador value
     * @param string $indicador
     * @return \StructType\DocumentoReferencia
     */
    public function setIndicador($indicador = null)
    {
        // validation for constraint: string
        if (!is_null($indicador) && !is_string($indicador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicador, true), gettype($indicador)), __LINE__);
        }
        $this->indicador = $indicador;
        return $this;
    }
    /**
     * Get tipoDocumentoReferencia value
     * @return string|null
     */
    public function getTipoDocumentoReferencia()
    {
        return $this->tipoDocumentoReferencia;
    }
    /**
     * Set tipoDocumentoReferencia value
     * @param string $tipoDocumentoReferencia
     * @return \StructType\DocumentoReferencia
     */
    public function setTipoDocumentoReferencia($tipoDocumentoReferencia = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumentoReferencia) && !is_string($tipoDocumentoReferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumentoReferencia, true), gettype($tipoDocumentoReferencia)), __LINE__);
        }
        $this->tipoDocumentoReferencia = $tipoDocumentoReferencia;
        return $this;
    }
    /**
     * Get numeroDocumentoReferencia value
     * @return string|null
     */
    public function getNumeroDocumentoReferencia()
    {
        return $this->numeroDocumentoReferencia;
    }
    /**
     * Set numeroDocumentoReferencia value
     * @param string $numeroDocumentoReferencia
     * @return \StructType\DocumentoReferencia
     */
    public function setNumeroDocumentoReferencia($numeroDocumentoReferencia = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDocumentoReferencia) && !is_string($numeroDocumentoReferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDocumentoReferencia, true), gettype($numeroDocumentoReferencia)), __LINE__);
        }
        $this->numeroDocumentoReferencia = $numeroDocumentoReferencia;
        return $this;
    }
}
