<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Replicate ServiceType
 * @subpackage Services
 */
class Replicate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named replicateXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplicateXml $parameters
     * @return \StructType\ReplicateXmlResponse|bool
     */
    public function replicateXml(\StructType\ReplicateXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->replicateXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReplicateXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
