<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://testing.bizlinks.com.pe/integrador21/ws/invoker?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://testing.bizlinks.com.pe/integrador21/ws/invoker?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Invoke ServiceType
 */
$invoke = new \ServiceType\Invoke($options);
/**
 * Sample call for invoke operation/method
 */
if ($invoke->invoke(new \StructType\Invoke()) !== false) {
    print_r($invoke->getResult());
} else {
    print_r($invoke->getLastError());
}
/**
 * Samples for Replicate ServiceType
 */
$replicate = new \ServiceType\Replicate($options);
/**
 * Sample call for replicateXml operation/method
 */
if ($replicate->replicateXml(new \StructType\ReplicateXml()) !== false) {
    print_r($replicate->getResult());
} else {
    print_r($replicate->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateAttachment operation/method
 */
if ($update->updateAttachment(new \StructType\UpdateAttachment()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
