<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xmlResult StructType
 * @subpackage Structs
 */
class XmlResult extends AbstractStructBase
{
    /**
     * The result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $result;
    /**
     * The document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentResult[]
     */
    public $document;
    /**
     * Constructor method for xmlResult
     * @uses XmlResult::setResult()
     * @uses XmlResult::setDocument()
     * @param string $result
     * @param \StructType\DocumentResult[] $document
     */
    public function __construct($result = null, array $document = array())
    {
        $this
            ->setResult($result)
            ->setDocument($document);
    }
    /**
     * Get result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param string $result
     * @return \StructType\XmlResult
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get document value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentResult[]|null
     */
    public function getDocument()
    {
        return isset($this->document) ? $this->document : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xmlResultDocumentItem) {
            // validation for constraint: itemType
            if (!$xmlResultDocumentItem instanceof \StructType\DocumentResult) {
                $invalidValues[] = is_object($xmlResultDocumentItem) ? get_class($xmlResultDocumentItem) : sprintf('%s(%s)', gettype($xmlResultDocumentItem), var_export($xmlResultDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The document property can only contain items of type \StructType\DocumentResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set document value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult[] $document
     * @return \StructType\XmlResult
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        if (is_null($document) || (is_array($document) && empty($document))) {
            unset($this->document);
        } else {
            $this->document = $document;
        }
        return $this;
    }
    /**
     * Add item to document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult $item
     * @return \StructType\XmlResult
     */
    public function addToDocument(\StructType\DocumentResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentResult) {
            throw new \InvalidArgumentException(sprintf('The document property can only contain items of type \StructType\DocumentResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->document[] = $item;
        return $this;
    }
}
