<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResumenItem StructType
 * @subpackage Structs
 */
class ResumenItem extends AbstractStructBase
{
    /**
     * The indicador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $indicador;
    /**
     * The numeroFila
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroFila;
    /**
     * The tipoDocumento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoDocumento;
    /**
     * The tipoMoneda
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoMoneda;
    /**
     * The serieDocumentoBaja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serieDocumentoBaja;
    /**
     * The numeroDocumentoBaja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroDocumentoBaja;
    /**
     * The motivoBaja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $motivoBaja;
    /**
     * The serieGrupoDocumento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serieGrupoDocumento;
    /**
     * The numeroCorrelativoInicio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroCorrelativoInicio;
    /**
     * The numeroCorrelativoFin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroCorrelativoFin;
    /**
     * The totalValorVentaOpGravadasConIgv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalValorVentaOpGravadasConIgv;
    /**
     * The totalValorVentaOpInafectasIgv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalValorVentaOpInafectasIgv;
    /**
     * The totalValorVentaOpGratuitas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalValorVentaOpGratuitas;
    /**
     * The totalOtrosTributos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalOtrosTributos;
    /**
     * The totalIgv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalIgv;
    /**
     * The totalVenta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalVenta;
    /**
     * The totalIsc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalIsc;
    /**
     * The totalOtrosCargos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalOtrosCargos;
    /**
     * The totalValorVentaOpExoneradasIgv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalValorVentaOpExoneradasIgv;
    /**
     * Constructor method for ResumenItem
     * @uses ResumenItem::setIndicador()
     * @uses ResumenItem::setNumeroFila()
     * @uses ResumenItem::setTipoDocumento()
     * @uses ResumenItem::setTipoMoneda()
     * @uses ResumenItem::setSerieDocumentoBaja()
     * @uses ResumenItem::setNumeroDocumentoBaja()
     * @uses ResumenItem::setMotivoBaja()
     * @uses ResumenItem::setSerieGrupoDocumento()
     * @uses ResumenItem::setNumeroCorrelativoInicio()
     * @uses ResumenItem::setNumeroCorrelativoFin()
     * @uses ResumenItem::setTotalValorVentaOpGravadasConIgv()
     * @uses ResumenItem::setTotalValorVentaOpInafectasIgv()
     * @uses ResumenItem::setTotalValorVentaOpGratuitas()
     * @uses ResumenItem::setTotalOtrosTributos()
     * @uses ResumenItem::setTotalIgv()
     * @uses ResumenItem::setTotalVenta()
     * @uses ResumenItem::setTotalIsc()
     * @uses ResumenItem::setTotalOtrosCargos()
     * @uses ResumenItem::setTotalValorVentaOpExoneradasIgv()
     * @param string $indicador
     * @param int $numeroFila
     * @param string $tipoDocumento
     * @param string $tipoMoneda
     * @param string $serieDocumentoBaja
     * @param string $numeroDocumentoBaja
     * @param string $motivoBaja
     * @param string $serieGrupoDocumento
     * @param string $numeroCorrelativoInicio
     * @param string $numeroCorrelativoFin
     * @param float $totalValorVentaOpGravadasConIgv
     * @param float $totalValorVentaOpInafectasIgv
     * @param float $totalValorVentaOpGratuitas
     * @param float $totalOtrosTributos
     * @param float $totalIgv
     * @param float $totalVenta
     * @param float $totalIsc
     * @param float $totalOtrosCargos
     * @param float $totalValorVentaOpExoneradasIgv
     */
    public function __construct($indicador = null, $numeroFila = null, $tipoDocumento = null, $tipoMoneda = null, $serieDocumentoBaja = null, $numeroDocumentoBaja = null, $motivoBaja = null, $serieGrupoDocumento = null, $numeroCorrelativoInicio = null, $numeroCorrelativoFin = null, $totalValorVentaOpGravadasConIgv = null, $totalValorVentaOpInafectasIgv = null, $totalValorVentaOpGratuitas = null, $totalOtrosTributos = null, $totalIgv = null, $totalVenta = null, $totalIsc = null, $totalOtrosCargos = null, $totalValorVentaOpExoneradasIgv = null)
    {
        $this
            ->setIndicador($indicador)
            ->setNumeroFila($numeroFila)
            ->setTipoDocumento($tipoDocumento)
            ->setTipoMoneda($tipoMoneda)
            ->setSerieDocumentoBaja($serieDocumentoBaja)
            ->setNumeroDocumentoBaja($numeroDocumentoBaja)
            ->setMotivoBaja($motivoBaja)
            ->setSerieGrupoDocumento($serieGrupoDocumento)
            ->setNumeroCorrelativoInicio($numeroCorrelativoInicio)
            ->setNumeroCorrelativoFin($numeroCorrelativoFin)
            ->setTotalValorVentaOpGravadasConIgv($totalValorVentaOpGravadasConIgv)
            ->setTotalValorVentaOpInafectasIgv($totalValorVentaOpInafectasIgv)
            ->setTotalValorVentaOpGratuitas($totalValorVentaOpGratuitas)
            ->setTotalOtrosTributos($totalOtrosTributos)
            ->setTotalIgv($totalIgv)
            ->setTotalVenta($totalVenta)
            ->setTotalIsc($totalIsc)
            ->setTotalOtrosCargos($totalOtrosCargos)
            ->setTotalValorVentaOpExoneradasIgv($totalValorVentaOpExoneradasIgv);
    }
    /**
     * Get indicador value
     * @return string|null
     */
    public function getIndicador()
    {
        return $this->indicador;
    }
    /**
     * Set indicador value
     * @param string $indicador
     * @return \StructType\ResumenItem
     */
    public function setIndicador($indicador = null)
    {
        // validation for constraint: string
        if (!is_null($indicador) && !is_string($indicador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicador, true), gettype($indicador)), __LINE__);
        }
        $this->indicador = $indicador;
        return $this;
    }
    /**
     * Get numeroFila value
     * @return int|null
     */
    public function getNumeroFila()
    {
        return $this->numeroFila;
    }
    /**
     * Set numeroFila value
     * @param int $numeroFila
     * @return \StructType\ResumenItem
     */
    public function setNumeroFila($numeroFila = null)
    {
        // validation for constraint: int
        if (!is_null($numeroFila) && !(is_int($numeroFila) || ctype_digit($numeroFila))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroFila, true), gettype($numeroFila)), __LINE__);
        }
        $this->numeroFila = $numeroFila;
        return $this;
    }
    /**
     * Get tipoDocumento value
     * @return string|null
     */
    public function getTipoDocumento()
    {
        return $this->tipoDocumento;
    }
    /**
     * Set tipoDocumento value
     * @param string $tipoDocumento
     * @return \StructType\ResumenItem
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumento) && !is_string($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumento, true), gettype($tipoDocumento)), __LINE__);
        }
        $this->tipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get tipoMoneda value
     * @return string|null
     */
    public function getTipoMoneda()
    {
        return $this->tipoMoneda;
    }
    /**
     * Set tipoMoneda value
     * @param string $tipoMoneda
     * @return \StructType\ResumenItem
     */
    public function setTipoMoneda($tipoMoneda = null)
    {
        // validation for constraint: string
        if (!is_null($tipoMoneda) && !is_string($tipoMoneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoMoneda, true), gettype($tipoMoneda)), __LINE__);
        }
        $this->tipoMoneda = $tipoMoneda;
        return $this;
    }
    /**
     * Get serieDocumentoBaja value
     * @return string|null
     */
    public function getSerieDocumentoBaja()
    {
        return $this->serieDocumentoBaja;
    }
    /**
     * Set serieDocumentoBaja value
     * @param string $serieDocumentoBaja
     * @return \StructType\ResumenItem
     */
    public function setSerieDocumentoBaja($serieDocumentoBaja = null)
    {
        // validation for constraint: string
        if (!is_null($serieDocumentoBaja) && !is_string($serieDocumentoBaja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serieDocumentoBaja, true), gettype($serieDocumentoBaja)), __LINE__);
        }
        $this->serieDocumentoBaja = $serieDocumentoBaja;
        return $this;
    }
    /**
     * Get numeroDocumentoBaja value
     * @return string|null
     */
    public function getNumeroDocumentoBaja()
    {
        return $this->numeroDocumentoBaja;
    }
    /**
     * Set numeroDocumentoBaja value
     * @param string $numeroDocumentoBaja
     * @return \StructType\ResumenItem
     */
    public function setNumeroDocumentoBaja($numeroDocumentoBaja = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDocumentoBaja) && !is_string($numeroDocumentoBaja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDocumentoBaja, true), gettype($numeroDocumentoBaja)), __LINE__);
        }
        $this->numeroDocumentoBaja = $numeroDocumentoBaja;
        return $this;
    }
    /**
     * Get motivoBaja value
     * @return string|null
     */
    public function getMotivoBaja()
    {
        return $this->motivoBaja;
    }
    /**
     * Set motivoBaja value
     * @param string $motivoBaja
     * @return \StructType\ResumenItem
     */
    public function setMotivoBaja($motivoBaja = null)
    {
        // validation for constraint: string
        if (!is_null($motivoBaja) && !is_string($motivoBaja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivoBaja, true), gettype($motivoBaja)), __LINE__);
        }
        $this->motivoBaja = $motivoBaja;
        return $this;
    }
    /**
     * Get serieGrupoDocumento value
     * @return string|null
     */
    public function getSerieGrupoDocumento()
    {
        return $this->serieGrupoDocumento;
    }
    /**
     * Set serieGrupoDocumento value
     * @param string $serieGrupoDocumento
     * @return \StructType\ResumenItem
     */
    public function setSerieGrupoDocumento($serieGrupoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($serieGrupoDocumento) && !is_string($serieGrupoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serieGrupoDocumento, true), gettype($serieGrupoDocumento)), __LINE__);
        }
        $this->serieGrupoDocumento = $serieGrupoDocumento;
        return $this;
    }
    /**
     * Get numeroCorrelativoInicio value
     * @return string|null
     */
    public function getNumeroCorrelativoInicio()
    {
        return $this->numeroCorrelativoInicio;
    }
    /**
     * Set numeroCorrelativoInicio value
     * @param string $numeroCorrelativoInicio
     * @return \StructType\ResumenItem
     */
    public function setNumeroCorrelativoInicio($numeroCorrelativoInicio = null)
    {
        // validation for constraint: string
        if (!is_null($numeroCorrelativoInicio) && !is_string($numeroCorrelativoInicio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroCorrelativoInicio, true), gettype($numeroCorrelativoInicio)), __LINE__);
        }
        $this->numeroCorrelativoInicio = $numeroCorrelativoInicio;
        return $this;
    }
    /**
     * Get numeroCorrelativoFin value
     * @return string|null
     */
    public function getNumeroCorrelativoFin()
    {
        return $this->numeroCorrelativoFin;
    }
    /**
     * Set numeroCorrelativoFin value
     * @param string $numeroCorrelativoFin
     * @return \StructType\ResumenItem
     */
    public function setNumeroCorrelativoFin($numeroCorrelativoFin = null)
    {
        // validation for constraint: string
        if (!is_null($numeroCorrelativoFin) && !is_string($numeroCorrelativoFin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroCorrelativoFin, true), gettype($numeroCorrelativoFin)), __LINE__);
        }
        $this->numeroCorrelativoFin = $numeroCorrelativoFin;
        return $this;
    }
    /**
     * Get totalValorVentaOpGravadasConIgv value
     * @return float|null
     */
    public function getTotalValorVentaOpGravadasConIgv()
    {
        return $this->totalValorVentaOpGravadasConIgv;
    }
    /**
     * Set totalValorVentaOpGravadasConIgv value
     * @param float $totalValorVentaOpGravadasConIgv
     * @return \StructType\ResumenItem
     */
    public function setTotalValorVentaOpGravadasConIgv($totalValorVentaOpGravadasConIgv = null)
    {
        // validation for constraint: float
        if (!is_null($totalValorVentaOpGravadasConIgv) && !(is_float($totalValorVentaOpGravadasConIgv) || is_numeric($totalValorVentaOpGravadasConIgv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalValorVentaOpGravadasConIgv, true), gettype($totalValorVentaOpGravadasConIgv)), __LINE__);
        }
        $this->totalValorVentaOpGravadasConIgv = $totalValorVentaOpGravadasConIgv;
        return $this;
    }
    /**
     * Get totalValorVentaOpInafectasIgv value
     * @return float|null
     */
    public function getTotalValorVentaOpInafectasIgv()
    {
        return $this->totalValorVentaOpInafectasIgv;
    }
    /**
     * Set totalValorVentaOpInafectasIgv value
     * @param float $totalValorVentaOpInafectasIgv
     * @return \StructType\ResumenItem
     */
    public function setTotalValorVentaOpInafectasIgv($totalValorVentaOpInafectasIgv = null)
    {
        // validation for constraint: float
        if (!is_null($totalValorVentaOpInafectasIgv) && !(is_float($totalValorVentaOpInafectasIgv) || is_numeric($totalValorVentaOpInafectasIgv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalValorVentaOpInafectasIgv, true), gettype($totalValorVentaOpInafectasIgv)), __LINE__);
        }
        $this->totalValorVentaOpInafectasIgv = $totalValorVentaOpInafectasIgv;
        return $this;
    }
    /**
     * Get totalValorVentaOpGratuitas value
     * @return float|null
     */
    public function getTotalValorVentaOpGratuitas()
    {
        return $this->totalValorVentaOpGratuitas;
    }
    /**
     * Set totalValorVentaOpGratuitas value
     * @param float $totalValorVentaOpGratuitas
     * @return \StructType\ResumenItem
     */
    public function setTotalValorVentaOpGratuitas($totalValorVentaOpGratuitas = null)
    {
        // validation for constraint: float
        if (!is_null($totalValorVentaOpGratuitas) && !(is_float($totalValorVentaOpGratuitas) || is_numeric($totalValorVentaOpGratuitas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalValorVentaOpGratuitas, true), gettype($totalValorVentaOpGratuitas)), __LINE__);
        }
        $this->totalValorVentaOpGratuitas = $totalValorVentaOpGratuitas;
        return $this;
    }
    /**
     * Get totalOtrosTributos value
     * @return float|null
     */
    public function getTotalOtrosTributos()
    {
        return $this->totalOtrosTributos;
    }
    /**
     * Set totalOtrosTributos value
     * @param float $totalOtrosTributos
     * @return \StructType\ResumenItem
     */
    public function setTotalOtrosTributos($totalOtrosTributos = null)
    {
        // validation for constraint: float
        if (!is_null($totalOtrosTributos) && !(is_float($totalOtrosTributos) || is_numeric($totalOtrosTributos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalOtrosTributos, true), gettype($totalOtrosTributos)), __LINE__);
        }
        $this->totalOtrosTributos = $totalOtrosTributos;
        return $this;
    }
    /**
     * Get totalIgv value
     * @return float|null
     */
    public function getTotalIgv()
    {
        return $this->totalIgv;
    }
    /**
     * Set totalIgv value
     * @param float $totalIgv
     * @return \StructType\ResumenItem
     */
    public function setTotalIgv($totalIgv = null)
    {
        // validation for constraint: float
        if (!is_null($totalIgv) && !(is_float($totalIgv) || is_numeric($totalIgv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalIgv, true), gettype($totalIgv)), __LINE__);
        }
        $this->totalIgv = $totalIgv;
        return $this;
    }
    /**
     * Get totalVenta value
     * @return float|null
     */
    public function getTotalVenta()
    {
        return $this->totalVenta;
    }
    /**
     * Set totalVenta value
     * @param float $totalVenta
     * @return \StructType\ResumenItem
     */
    public function setTotalVenta($totalVenta = null)
    {
        // validation for constraint: float
        if (!is_null($totalVenta) && !(is_float($totalVenta) || is_numeric($totalVenta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalVenta, true), gettype($totalVenta)), __LINE__);
        }
        $this->totalVenta = $totalVenta;
        return $this;
    }
    /**
     * Get totalIsc value
     * @return float|null
     */
    public function getTotalIsc()
    {
        return $this->totalIsc;
    }
    /**
     * Set totalIsc value
     * @param float $totalIsc
     * @return \StructType\ResumenItem
     */
    public function setTotalIsc($totalIsc = null)
    {
        // validation for constraint: float
        if (!is_null($totalIsc) && !(is_float($totalIsc) || is_numeric($totalIsc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalIsc, true), gettype($totalIsc)), __LINE__);
        }
        $this->totalIsc = $totalIsc;
        return $this;
    }
    /**
     * Get totalOtrosCargos value
     * @return float|null
     */
    public function getTotalOtrosCargos()
    {
        return $this->totalOtrosCargos;
    }
    /**
     * Set totalOtrosCargos value
     * @param float $totalOtrosCargos
     * @return \StructType\ResumenItem
     */
    public function setTotalOtrosCargos($totalOtrosCargos = null)
    {
        // validation for constraint: float
        if (!is_null($totalOtrosCargos) && !(is_float($totalOtrosCargos) || is_numeric($totalOtrosCargos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalOtrosCargos, true), gettype($totalOtrosCargos)), __LINE__);
        }
        $this->totalOtrosCargos = $totalOtrosCargos;
        return $this;
    }
    /**
     * Get totalValorVentaOpExoneradasIgv value
     * @return float|null
     */
    public function getTotalValorVentaOpExoneradasIgv()
    {
        return $this->totalValorVentaOpExoneradasIgv;
    }
    /**
     * Set totalValorVentaOpExoneradasIgv value
     * @param float $totalValorVentaOpExoneradasIgv
     * @return \StructType\ResumenItem
     */
    public function setTotalValorVentaOpExoneradasIgv($totalValorVentaOpExoneradasIgv = null)
    {
        // validation for constraint: float
        if (!is_null($totalValorVentaOpExoneradasIgv) && !(is_float($totalValorVentaOpExoneradasIgv) || is_numeric($totalValorVentaOpExoneradasIgv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalValorVentaOpExoneradasIgv, true), gettype($totalValorVentaOpExoneradasIgv)), __LINE__);
        }
        $this->totalValorVentaOpExoneradasIgv = $totalValorVentaOpExoneradasIgv;
        return $this;
    }
}
