<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for invoke StructType
 * Meta information extracted from the WSDL
 * - type: tns:invoke
 * @subpackage Structs
 */
class Invoke extends AbstractStructBase
{
    /**
     * The command
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $command;
    /**
     * Constructor method for invoke
     * @uses Invoke::setCommand()
     * @param string $command
     */
    public function __construct($command = null)
    {
        $this
            ->setCommand($command);
    }
    /**
     * Get command value
     * @return string|null
     */
    public function getCommand()
    {
        return $this->command;
    }
    /**
     * Set command value
     * @param string $command
     * @return \StructType\Invoke
     */
    public function setCommand($command = null)
    {
        // validation for constraint: string
        if (!is_null($command) && !is_string($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($command, true), gettype($command)), __LINE__);
        }
        $this->command = $command;
        return $this;
    }
}
