<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for defaultResult StructType
 * @subpackage Structs
 */
class DefaultResult extends AbstractStructBase
{
    /**
     * The messages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Message[]
     */
    public $messages;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The statusDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $statusDescription;
    /**
     * The xmlText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $xmlText;
    /**
     * Constructor method for defaultResult
     * @uses DefaultResult::setMessages()
     * @uses DefaultResult::setStatus()
     * @uses DefaultResult::setStatusDescription()
     * @uses DefaultResult::setXmlText()
     * @param \StructType\Message[] $messages
     * @param string $status
     * @param string $statusDescription
     * @param string $xmlText
     */
    public function __construct(array $messages = array(), $status = null, $statusDescription = null, $xmlText = null)
    {
        $this
            ->setMessages($messages)
            ->setStatus($status)
            ->setStatusDescription($statusDescription)
            ->setXmlText($xmlText);
    }
    /**
     * Get messages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Message[]|null
     */
    public function getMessages()
    {
        return isset($this->messages) ? $this->messages : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMessages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessagesForArrayConstraintsFromSetMessages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $defaultResultMessagesItem) {
            // validation for constraint: itemType
            if (!$defaultResultMessagesItem instanceof \StructType\Message) {
                $invalidValues[] = is_object($defaultResultMessagesItem) ? get_class($defaultResultMessagesItem) : sprintf('%s(%s)', gettype($defaultResultMessagesItem), var_export($defaultResultMessagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The messages property can only contain items of type \StructType\Message, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set messages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Message[] $messages
     * @return \StructType\DefaultResult
     */
    public function setMessages(array $messages = array())
    {
        // validation for constraint: array
        if ('' !== ($messagesArrayErrorMessage = self::validateMessagesForArrayConstraintsFromSetMessages($messages))) {
            throw new \InvalidArgumentException($messagesArrayErrorMessage, __LINE__);
        }
        if (is_null($messages) || (is_array($messages) && empty($messages))) {
            unset($this->messages);
        } else {
            $this->messages = $messages;
        }
        return $this;
    }
    /**
     * Add item to messages value
     * @throws \InvalidArgumentException
     * @param \StructType\Message $item
     * @return \StructType\DefaultResult
     */
    public function addToMessages(\StructType\Message $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Message) {
            throw new \InvalidArgumentException(sprintf('The messages property can only contain items of type \StructType\Message, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->messages[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\DefaultResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get statusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->statusDescription;
    }
    /**
     * Set statusDescription value
     * @param string $statusDescription
     * @return \StructType\DefaultResult
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        $this->statusDescription = $statusDescription;
        return $this;
    }
    /**
     * Get xmlText value
     * @return string|null
     */
    public function getXmlText()
    {
        return $this->xmlText;
    }
    /**
     * Set xmlText value
     * @param string $xmlText
     * @return \StructType\DefaultResult
     */
    public function setXmlText($xmlText = null)
    {
        // validation for constraint: string
        if (!is_null($xmlText) && !is_string($xmlText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlText, true), gettype($xmlText)), __LINE__);
        }
        $this->xmlText = $xmlText;
        return $this;
    }
}
