<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for consultResult StructType
 * @subpackage Structs
 */
class ConsultResult extends AbstractStructBase
{
    /**
     * The documentResults
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentResult[]
     */
    public $documentResults;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The statusDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $statusDescription;
    /**
     * Constructor method for consultResult
     * @uses ConsultResult::setDocumentResults()
     * @uses ConsultResult::setStatus()
     * @uses ConsultResult::setStatusDescription()
     * @param \StructType\DocumentResult[] $documentResults
     * @param string $status
     * @param string $statusDescription
     */
    public function __construct(array $documentResults = array(), $status = null, $statusDescription = null)
    {
        $this
            ->setDocumentResults($documentResults)
            ->setStatus($status)
            ->setStatusDescription($statusDescription);
    }
    /**
     * Get documentResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentResult[]|null
     */
    public function getDocumentResults()
    {
        return isset($this->documentResults) ? $this->documentResults : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentResults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentResults method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentResultsForArrayConstraintsFromSetDocumentResults(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consultResultDocumentResultsItem) {
            // validation for constraint: itemType
            if (!$consultResultDocumentResultsItem instanceof \StructType\DocumentResult) {
                $invalidValues[] = is_object($consultResultDocumentResultsItem) ? get_class($consultResultDocumentResultsItem) : sprintf('%s(%s)', gettype($consultResultDocumentResultsItem), var_export($consultResultDocumentResultsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The documentResults property can only contain items of type \StructType\DocumentResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set documentResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult[] $documentResults
     * @return \StructType\ConsultResult
     */
    public function setDocumentResults(array $documentResults = array())
    {
        // validation for constraint: array
        if ('' !== ($documentResultsArrayErrorMessage = self::validateDocumentResultsForArrayConstraintsFromSetDocumentResults($documentResults))) {
            throw new \InvalidArgumentException($documentResultsArrayErrorMessage, __LINE__);
        }
        if (is_null($documentResults) || (is_array($documentResults) && empty($documentResults))) {
            unset($this->documentResults);
        } else {
            $this->documentResults = $documentResults;
        }
        return $this;
    }
    /**
     * Add item to documentResults value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult $item
     * @return \StructType\ConsultResult
     */
    public function addToDocumentResults(\StructType\DocumentResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentResult) {
            throw new \InvalidArgumentException(sprintf('The documentResults property can only contain items of type \StructType\DocumentResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->documentResults[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\ConsultResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get statusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->statusDescription;
    }
    /**
     * Set statusDescription value
     * @param string $statusDescription
     * @return \StructType\ConsultResult
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        $this->statusDescription = $statusDescription;
        return $this;
    }
}
