<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for commonResponse StructType
 * @subpackage Structs
 */
class CommonResponse extends AbstractStructBase
{
    /**
     * The summaryResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SummaryResult
     */
    public $summaryResult;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The descriptionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descriptionStatus;
    /**
     * The messages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Message[]
     */
    public $messages;
    /**
     * Constructor method for commonResponse
     * @uses CommonResponse::setSummaryResult()
     * @uses CommonResponse::setStatus()
     * @uses CommonResponse::setDescriptionStatus()
     * @uses CommonResponse::setMessages()
     * @param \StructType\SummaryResult $summaryResult
     * @param string $status
     * @param string $descriptionStatus
     * @param \StructType\Message[] $messages
     */
    public function __construct(\StructType\SummaryResult $summaryResult = null, $status = null, $descriptionStatus = null, array $messages = array())
    {
        $this
            ->setSummaryResult($summaryResult)
            ->setStatus($status)
            ->setDescriptionStatus($descriptionStatus)
            ->setMessages($messages);
    }
    /**
     * Get summaryResult value
     * @return \StructType\SummaryResult|null
     */
    public function getSummaryResult()
    {
        return $this->summaryResult;
    }
    /**
     * Set summaryResult value
     * @param \StructType\SummaryResult $summaryResult
     * @return \StructType\CommonResponse
     */
    public function setSummaryResult(\StructType\SummaryResult $summaryResult = null)
    {
        $this->summaryResult = $summaryResult;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\CommonResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get descriptionStatus value
     * @return string|null
     */
    public function getDescriptionStatus()
    {
        return $this->descriptionStatus;
    }
    /**
     * Set descriptionStatus value
     * @param string $descriptionStatus
     * @return \StructType\CommonResponse
     */
    public function setDescriptionStatus($descriptionStatus = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionStatus) && !is_string($descriptionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionStatus, true), gettype($descriptionStatus)), __LINE__);
        }
        $this->descriptionStatus = $descriptionStatus;
        return $this;
    }
    /**
     * Get messages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Message[]|null
     */
    public function getMessages()
    {
        return isset($this->messages) ? $this->messages : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMessages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessagesForArrayConstraintsFromSetMessages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonResponseMessagesItem) {
            // validation for constraint: itemType
            if (!$commonResponseMessagesItem instanceof \StructType\Message) {
                $invalidValues[] = is_object($commonResponseMessagesItem) ? get_class($commonResponseMessagesItem) : sprintf('%s(%s)', gettype($commonResponseMessagesItem), var_export($commonResponseMessagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The messages property can only contain items of type \StructType\Message, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set messages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Message[] $messages
     * @return \StructType\CommonResponse
     */
    public function setMessages(array $messages = array())
    {
        // validation for constraint: array
        if ('' !== ($messagesArrayErrorMessage = self::validateMessagesForArrayConstraintsFromSetMessages($messages))) {
            throw new \InvalidArgumentException($messagesArrayErrorMessage, __LINE__);
        }
        if (is_null($messages) || (is_array($messages) && empty($messages))) {
            unset($this->messages);
        } else {
            $this->messages = $messages;
        }
        return $this;
    }
    /**
     * Add item to messages value
     * @throws \InvalidArgumentException
     * @param \StructType\Message $item
     * @return \StructType\CommonResponse
     */
    public function addToMessages(\StructType\Message $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Message) {
            throw new \InvalidArgumentException(sprintf('The messages property can only contain items of type \StructType\Message, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->messages[] = $item;
        return $this;
    }
}
