<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adicionales StructType
 * @subpackage Structs
 */
class Adicionales extends AbstractStructBase
{
    /**
     * The adicional
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Adicional[]
     */
    public $adicional;
    /**
     * Constructor method for adicionales
     * @uses Adicionales::setAdicional()
     * @param \StructType\Adicional[] $adicional
     */
    public function __construct(array $adicional = array())
    {
        $this
            ->setAdicional($adicional);
    }
    /**
     * Get adicional value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Adicional[]|null
     */
    public function getAdicional()
    {
        return isset($this->adicional) ? $this->adicional : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAdicional method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdicional method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdicionalForArrayConstraintsFromSetAdicional(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adicionalesAdicionalItem) {
            // validation for constraint: itemType
            if (!$adicionalesAdicionalItem instanceof \StructType\Adicional) {
                $invalidValues[] = is_object($adicionalesAdicionalItem) ? get_class($adicionalesAdicionalItem) : sprintf('%s(%s)', gettype($adicionalesAdicionalItem), var_export($adicionalesAdicionalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The adicional property can only contain items of type \StructType\Adicional, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set adicional value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Adicional[] $adicional
     * @return \StructType\Adicionales
     */
    public function setAdicional(array $adicional = array())
    {
        // validation for constraint: array
        if ('' !== ($adicionalArrayErrorMessage = self::validateAdicionalForArrayConstraintsFromSetAdicional($adicional))) {
            throw new \InvalidArgumentException($adicionalArrayErrorMessage, __LINE__);
        }
        if (is_null($adicional) || (is_array($adicional) && empty($adicional))) {
            unset($this->adicional);
        } else {
            $this->adicional = $adicional;
        }
        return $this;
    }
    /**
     * Add item to adicional value
     * @throws \InvalidArgumentException
     * @param \StructType\Adicional $item
     * @return \StructType\Adicionales
     */
    public function addToAdicional(\StructType\Adicional $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Adicional) {
            throw new \InvalidArgumentException(sprintf('The adicional property can only contain items of type \StructType\Adicional, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->adicional[] = $item;
        return $this;
    }
}
