<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adicional StructType
 * @subpackage Structs
 */
class Adicional extends AbstractStructBase
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigo;
    /**
     * The valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $valor;
    /**
     * Constructor method for adicional
     * @uses Adicional::setCodigo()
     * @uses Adicional::setValor()
     * @param string $codigo
     * @param string $valor
     */
    public function __construct($codigo = null, $valor = null)
    {
        $this
            ->setCodigo($codigo)
            ->setValor($valor);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\Adicional
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get valor value
     * @return string|null
     */
    public function getValor()
    {
        return $this->valor;
    }
    /**
     * Set valor value
     * @param string $valor
     * @return \StructType\Adicional
     */
    public function setValor($valor = null)
    {
        // validation for constraint: string
        if (!is_null($valor) && !is_string($valor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->valor = $valor;
        return $this;
    }
}
