<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Payktm\ClassMap::get(),
);
/**
 * Samples for ET ServiceType
 */
$eT = new \Payktm\ServiceType\ET($options);
/**
 * Sample call for eTopupModify operation/method
 */
if ($eT->eTopupModify(new \Payktm\StructType\ETopupModify()) !== false) {
    print_r($eT->getResult());
} else {
    print_r($eT->getLastError());
}
/**
 * Sample call for eTopupThresholdCheck operation/method
 */
if ($eT->eTopupThresholdCheck(new \Payktm\StructType\ETopupThresholdCheck()) !== false) {
    print_r($eT->getResult());
} else {
    print_r($eT->getLastError());
}
/**
 * Sample call for eTopupRecordQuery2 operation/method
 */
if ($eT->eTopupRecordQuery2(new \Payktm\StructType\ETopupRecordQuery2()) !== false) {
    print_r($eT->getResult());
} else {
    print_r($eT->getLastError());
}
/**
 * Sample call for eTopupRecordQuery operation/method
 */
if ($eT->eTopupRecordQuery(new \Payktm\StructType\ETopupRecordQuery()) !== false) {
    print_r($eT->getResult());
} else {
    print_r($eT->getLastError());
}
/**
 * Sample call for eTopupTransfer operation/method
 */
if ($eT->eTopupTransfer(new \Payktm\StructType\ETopupTransfer()) !== false) {
    print_r($eT->getResult());
} else {
    print_r($eT->getLastError());
}
/**
 * Sample call for eTopupRollback operation/method
 */
if ($eT->eTopupRollback(new \Payktm\StructType\ETopupRollback()) !== false) {
    print_r($eT->getResult());
} else {
    print_r($eT->getLastError());
}
/**
 * Samples for Dealer ServiceType
 */
$dealer = new \Payktm\ServiceType\Dealer($options);
/**
 * Sample call for dealerAllInfoQuery operation/method
 */
if ($dealer->dealerAllInfoQuery(new \Payktm\StructType\DealerAllInfoQuery()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerServiceInfoUpdate operation/method
 */
if ($dealer->dealerServiceInfoUpdate(new \Payktm\StructType\DealerServiceInfoUpdate()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerInfoModify operation/method
 */
if ($dealer->dealerInfoModify(new \Payktm\StructType\DealerInfoModify()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerFileInfoSave operation/method
 */
if ($dealer->dealerFileInfoSave(new \Payktm\StructType\DealerFileInfoSave()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerServiceMaxQTYQry operation/method
 */
if ($dealer->dealerServiceMaxQTYQry(new \Payktm\StructType\DealerServiceMaxQTYQry()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerFileInfoUpdate operation/method
 */
if ($dealer->dealerFileInfoUpdate(new \Payktm\StructType\DealerFileInfoUpdate()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerServiceInfoSave operation/method
 */
if ($dealer->dealerServiceInfoSave(new \Payktm\StructType\DealerServiceInfoSave()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerApplySave operation/method
 */
if ($dealer->dealerApplySave(new \Payktm\StructType\DealerApplySave()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerFileInfoDelete operation/method
 */
if ($dealer->dealerFileInfoDelete(new \Payktm\StructType\DealerFileInfoDelete()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerPasswordChg operation/method
 */
if ($dealer->dealerPasswordChg(new \Payktm\StructType\DealerPasswordChg()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerInfoQueryByContactPhone operation/method
 */
if ($dealer->dealerInfoQueryByContactPhone(new \Payktm\StructType\DealerInfoQueryByContactPhone()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerTradePasswordChg operation/method
 */
if ($dealer->dealerTradePasswordChg(new \Payktm\StructType\DealerTradePasswordChg()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerInfoQuery operation/method
 */
if ($dealer->dealerInfoQuery(new \Payktm\StructType\DealerInfoQuery()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Sample call for dealerFileInfoQuery operation/method
 */
if ($dealer->dealerFileInfoQuery(new \Payktm\StructType\DealerFileInfoQuery()) !== false) {
    print_r($dealer->getResult());
} else {
    print_r($dealer->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \Payktm\ServiceType\Check($options);
/**
 * Sample call for checkMposNoIsRepeat operation/method
 */
if ($check->checkMposNoIsRepeat(new \Payktm\StructType\CheckMposNoIsRepeat()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkDealerPassword operation/method
 */
if ($check->checkDealerPassword(new \Payktm\StructType\CheckDealerPassword()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkDealerSalesBillId operation/method
 */
if ($check->checkDealerSalesBillId(new \Payktm\StructType\CheckDealerSalesBillId()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkDealer operation/method
 */
if ($check->checkDealer(new \Payktm\StructType\CheckDealer()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Select ServiceType
 */
$select = new \Payktm\ServiceType\Select($options);
/**
 * Sample call for selectServiceQuery operation/method
 */
if ($select->selectServiceQuery(new \Payktm\StructType\SelectServiceQuery()) !== false) {
    print_r($select->getResult());
} else {
    print_r($select->getLastError());
}
/**
 * Samples for Transfer ServiceType
 */
$transfer = new \Payktm\ServiceType\Transfer($options);
/**
 * Sample call for transferRecordQuery operation/method
 */
if ($transfer->transferRecordQuery(new \Payktm\StructType\TransferRecordQuery()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for transferCancel operation/method
 */
if ($transfer->transferCancel(new \Payktm\StructType\TransferCancel()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \Payktm\ServiceType\Get($options);
/**
 * Sample call for getDealerBalance operation/method
 */
if ($get->getDealerBalance(new \Payktm\StructType\GetDealerBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStaticDataByCodeType operation/method
 */
if ($get->getStaticDataByCodeType(new \Payktm\StructType\GetStaticDataByCodeType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSRECardInfo operation/method
 */
if ($get->getSRECardInfo(new \Payktm\StructType\GetSRECardInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDealerSaleCardInfo operation/method
 */
if ($get->getDealerSaleCardInfo(new \Payktm\StructType\GetDealerSaleCardInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDealerCardInfo operation/method
 */
if ($get->getDealerCardInfo(new \Payktm\StructType\GetDealerCardInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllOrganize operation/method
 */
if ($get->getAllOrganize(new \Payktm\StructType\GetAllOrganize()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Docheck ServiceType
 */
$docheck = new \Payktm\ServiceType\Docheck($options);
/**
 * Sample call for do_checkDealer operation/method
 */
if ($docheck->do_checkDealer(new \Payktm\StructType\Do_checkDealer()) !== false) {
    print_r($docheck->getResult());
} else {
    print_r($docheck->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \Payktm\ServiceType\Delete($options);
/**
 * Sample call for deleteRetailers operation/method
 */
if ($delete->deleteRetailers(new \Payktm\StructType\DeleteRetailers()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteServiceInfoSave operation/method
 */
if ($delete->deleteServiceInfoSave(new \Payktm\StructType\DeleteServiceInfoSave()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Judge ServiceType
 */
$judge = new \Payktm\ServiceType\Judge($options);
/**
 * Sample call for judgeMposIsNormalPhone operation/method
 */
if ($judge->judgeMposIsNormalPhone(new \Payktm\StructType\JudgeMposIsNormalPhone()) !== false) {
    print_r($judge->getResult());
} else {
    print_r($judge->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \Payktm\ServiceType\Save($options);
/**
 * Sample call for saveDealerCardInfo operation/method
 */
if ($save->saveDealerCardInfo(new \Payktm\StructType\SaveDealerCardInfo()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Valid ServiceType
 */
$valid = new \Payktm\ServiceType\Valid($options);
/**
 * Sample call for validDealerForBatch operation/method
 */
if ($valid->validDealerForBatch(new \Payktm\StructType\ValidDealerForBatch()) !== false) {
    print_r($valid->getResult());
} else {
    print_r($valid->getLastError());
}
/**
 * Samples for Card ServiceType
 */
$card = new \Payktm\ServiceType\Card($options);
/**
 * Sample call for cardRecall operation/method
 */
if ($card->cardRecall(new \Payktm\StructType\CardRecall()) !== false) {
    print_r($card->getResult());
} else {
    print_r($card->getLastError());
}
/**
 * Samples for Un ServiceType
 */
$un = new \Payktm\ServiceType\Un($options);
/**
 * Sample call for unSelectServiceQuery operation/method
 */
if ($un->unSelectServiceQuery(new \Payktm\StructType\UnSelectServiceQuery()) !== false) {
    print_r($un->getResult());
} else {
    print_r($un->getLastError());
}
