<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsDemandSummaryRsp StructType
 * @subpackage Structs
 */
class WsDemandSummaryRsp extends AbstractStructBase
{
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * The wsDemandSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\WsDemandSummary[]
     */
    public $wsDemandSummary;
    /**
     * Constructor method for WsDemandSummaryRsp
     * @uses WsDemandSummaryRsp::setRespCode()
     * @uses WsDemandSummaryRsp::setRespDesc()
     * @uses WsDemandSummaryRsp::setWsDemandSummary()
     * @param string $respCode
     * @param string $respDesc
     * @param \Payktm\StructType\WsDemandSummary[] $wsDemandSummary
     */
    public function __construct($respCode = null, $respDesc = null, array $wsDemandSummary = array())
    {
        $this
            ->setRespCode($respCode)
            ->setRespDesc($respDesc)
            ->setWsDemandSummary($wsDemandSummary);
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\WsDemandSummaryRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\WsDemandSummaryRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Get wsDemandSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\WsDemandSummary[]|null
     */
    public function getWsDemandSummary()
    {
        return isset($this->wsDemandSummary) ? $this->wsDemandSummary : null;
    }
    /**
     * Set wsDemandSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\WsDemandSummary[] $wsDemandSummary
     * @return \Payktm\StructType\WsDemandSummaryRsp
     */
    public function setWsDemandSummary(array $wsDemandSummary = array())
    {
        foreach ($wsDemandSummary as $wsDemandSummaryRspWsDemandSummaryItem) {
            // validation for constraint: itemType
            if (!$wsDemandSummaryRspWsDemandSummaryItem instanceof \Payktm\StructType\WsDemandSummary) {
                throw new \InvalidArgumentException(sprintf('The wsDemandSummary property can only contain items of \Payktm\StructType\WsDemandSummary, "%s" given', is_object($wsDemandSummaryRspWsDemandSummaryItem) ? get_class($wsDemandSummaryRspWsDemandSummaryItem) : gettype($wsDemandSummaryRspWsDemandSummaryItem)), __LINE__);
            }
        }
        if (is_null($wsDemandSummary) || (is_array($wsDemandSummary) && empty($wsDemandSummary))) {
            unset($this->wsDemandSummary);
        } else {
            $this->wsDemandSummary = $wsDemandSummary;
        }
        return $this;
    }
    /**
     * Add item to wsDemandSummary value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\WsDemandSummary $item
     * @return \Payktm\StructType\WsDemandSummaryRsp
     */
    public function addToWsDemandSummary(\Payktm\StructType\WsDemandSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\WsDemandSummary) {
            throw new \InvalidArgumentException(sprintf('The wsDemandSummary property can only contain items of \Payktm\StructType\WsDemandSummary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->wsDemandSummary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\WsDemandSummaryRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
