<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnSelectService StructType
 * @subpackage Structs
 */
class UnSelectService extends AbstractStructBase
{
    /**
     * The depositConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DepositConfig[]
     */
    public $depositConfig;
    /**
     * The serviceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceName;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceType;
    /**
     * Constructor method for UnSelectService
     * @uses UnSelectService::setDepositConfig()
     * @uses UnSelectService::setServiceName()
     * @uses UnSelectService::setServiceType()
     * @param \Payktm\StructType\DepositConfig[] $depositConfig
     * @param string $serviceName
     * @param string $serviceType
     */
    public function __construct(array $depositConfig = array(), $serviceName = null, $serviceType = null)
    {
        $this
            ->setDepositConfig($depositConfig)
            ->setServiceName($serviceName)
            ->setServiceType($serviceType);
    }
    /**
     * Get depositConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DepositConfig[]|null
     */
    public function getDepositConfig()
    {
        return isset($this->depositConfig) ? $this->depositConfig : null;
    }
    /**
     * Set depositConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DepositConfig[] $depositConfig
     * @return \Payktm\StructType\UnSelectService
     */
    public function setDepositConfig(array $depositConfig = array())
    {
        foreach ($depositConfig as $unSelectServiceDepositConfigItem) {
            // validation for constraint: itemType
            if (!$unSelectServiceDepositConfigItem instanceof \Payktm\StructType\DepositConfig) {
                throw new \InvalidArgumentException(sprintf('The depositConfig property can only contain items of \Payktm\StructType\DepositConfig, "%s" given', is_object($unSelectServiceDepositConfigItem) ? get_class($unSelectServiceDepositConfigItem) : gettype($unSelectServiceDepositConfigItem)), __LINE__);
            }
        }
        if (is_null($depositConfig) || (is_array($depositConfig) && empty($depositConfig))) {
            unset($this->depositConfig);
        } else {
            $this->depositConfig = $depositConfig;
        }
        return $this;
    }
    /**
     * Add item to depositConfig value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DepositConfig $item
     * @return \Payktm\StructType\UnSelectService
     */
    public function addToDepositConfig(\Payktm\StructType\DepositConfig $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\DepositConfig) {
            throw new \InvalidArgumentException(sprintf('The depositConfig property can only contain items of \Payktm\StructType\DepositConfig, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->depositConfig[] = $item;
        return $this;
    }
    /**
     * Get serviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceName()
    {
        return isset($this->serviceName) ? $this->serviceName : null;
    }
    /**
     * Set serviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceName
     * @return \Payktm\StructType\UnSelectService
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceName)), __LINE__);
        }
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->serviceName);
        } else {
            $this->serviceName = $serviceName;
        }
        return $this;
    }
    /**
     * Get serviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceType()
    {
        return isset($this->serviceType) ? $this->serviceType : null;
    }
    /**
     * Set serviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceType
     * @return \Payktm\StructType\UnSelectService
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        if (is_null($serviceType) || (is_array($serviceType) && empty($serviceType))) {
            unset($this->serviceType);
        } else {
            $this->serviceType = $serviceType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\UnSelectService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
