<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectServiceRsp StructType
 * @subpackage Structs
 */
class SelectServiceRsp extends AbstractStructBase
{
    /**
     * The dealerService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerService[]
     */
    public $dealerService;
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * Constructor method for SelectServiceRsp
     * @uses SelectServiceRsp::setDealerService()
     * @uses SelectServiceRsp::setRespCode()
     * @uses SelectServiceRsp::setRespDesc()
     * @param \Payktm\StructType\DealerService[] $dealerService
     * @param string $respCode
     * @param string $respDesc
     */
    public function __construct(array $dealerService = array(), $respCode = null, $respDesc = null)
    {
        $this
            ->setDealerService($dealerService)
            ->setRespCode($respCode)
            ->setRespDesc($respDesc);
    }
    /**
     * Get dealerService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerService[]|null
     */
    public function getDealerService()
    {
        return isset($this->dealerService) ? $this->dealerService : null;
    }
    /**
     * Set dealerService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerService[] $dealerService
     * @return \Payktm\StructType\SelectServiceRsp
     */
    public function setDealerService(array $dealerService = array())
    {
        foreach ($dealerService as $selectServiceRspDealerServiceItem) {
            // validation for constraint: itemType
            if (!$selectServiceRspDealerServiceItem instanceof \Payktm\StructType\DealerService) {
                throw new \InvalidArgumentException(sprintf('The dealerService property can only contain items of \Payktm\StructType\DealerService, "%s" given', is_object($selectServiceRspDealerServiceItem) ? get_class($selectServiceRspDealerServiceItem) : gettype($selectServiceRspDealerServiceItem)), __LINE__);
            }
        }
        if (is_null($dealerService) || (is_array($dealerService) && empty($dealerService))) {
            unset($this->dealerService);
        } else {
            $this->dealerService = $dealerService;
        }
        return $this;
    }
    /**
     * Add item to dealerService value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerService $item
     * @return \Payktm\StructType\SelectServiceRsp
     */
    public function addToDealerService(\Payktm\StructType\DealerService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\DealerService) {
            throw new \InvalidArgumentException(sprintf('The dealerService property can only contain items of \Payktm\StructType\DealerService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dealerService[] = $item;
        return $this;
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\SelectServiceRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\SelectServiceRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\SelectServiceRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
