<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecOrganize StructType
 * @subpackage Structs
 */
class SecOrganize extends AbstractStructBase
{
    /**
     * The orgId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orgId;
    /**
     * The orgName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orgName;
    /**
     * The parentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parentId;
    /**
     * Constructor method for SecOrganize
     * @uses SecOrganize::setOrgId()
     * @uses SecOrganize::setOrgName()
     * @uses SecOrganize::setParentId()
     * @param string $orgId
     * @param string $orgName
     * @param string $parentId
     */
    public function __construct($orgId = null, $orgName = null, $parentId = null)
    {
        $this
            ->setOrgId($orgId)
            ->setOrgName($orgName)
            ->setParentId($parentId);
    }
    /**
     * Get orgId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgId()
    {
        return isset($this->orgId) ? $this->orgId : null;
    }
    /**
     * Set orgId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgId
     * @return \Payktm\StructType\SecOrganize
     */
    public function setOrgId($orgId = null)
    {
        // validation for constraint: string
        if (!is_null($orgId) && !is_string($orgId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgId)), __LINE__);
        }
        if (is_null($orgId) || (is_array($orgId) && empty($orgId))) {
            unset($this->orgId);
        } else {
            $this->orgId = $orgId;
        }
        return $this;
    }
    /**
     * Get orgName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgName()
    {
        return isset($this->orgName) ? $this->orgName : null;
    }
    /**
     * Set orgName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgName
     * @return \Payktm\StructType\SecOrganize
     */
    public function setOrgName($orgName = null)
    {
        // validation for constraint: string
        if (!is_null($orgName) && !is_string($orgName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgName)), __LINE__);
        }
        if (is_null($orgName) || (is_array($orgName) && empty($orgName))) {
            unset($this->orgName);
        } else {
            $this->orgName = $orgName;
        }
        return $this;
    }
    /**
     * Get parentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->parentId) ? $this->parentId : null;
    }
    /**
     * Set parentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \Payktm\StructType\SecOrganize
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentId)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->parentId);
        } else {
            $this->parentId = $parentId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\SecOrganize
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
