<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseCheckDealer StructType
 * @subpackage Structs
 */
class ResponseCheckDealer extends AbstractStructBase
{
    /**
     * The checkDealerRsp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\CheckDealerRsp
     */
    public $checkDealerRsp;
    /**
     * The responseHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\ResponseHeader
     */
    public $responseHeader;
    /**
     * Constructor method for ResponseCheckDealer
     * @uses ResponseCheckDealer::setCheckDealerRsp()
     * @uses ResponseCheckDealer::setResponseHeader()
     * @param \Payktm\StructType\CheckDealerRsp $checkDealerRsp
     * @param \Payktm\StructType\ResponseHeader $responseHeader
     */
    public function __construct(\Payktm\StructType\CheckDealerRsp $checkDealerRsp = null, \Payktm\StructType\ResponseHeader $responseHeader = null)
    {
        $this
            ->setCheckDealerRsp($checkDealerRsp)
            ->setResponseHeader($responseHeader);
    }
    /**
     * Get checkDealerRsp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\CheckDealerRsp|null
     */
    public function getCheckDealerRsp()
    {
        return isset($this->checkDealerRsp) ? $this->checkDealerRsp : null;
    }
    /**
     * Set checkDealerRsp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\CheckDealerRsp $checkDealerRsp
     * @return \Payktm\StructType\ResponseCheckDealer
     */
    public function setCheckDealerRsp(\Payktm\StructType\CheckDealerRsp $checkDealerRsp = null)
    {
        if (is_null($checkDealerRsp) || (is_array($checkDealerRsp) && empty($checkDealerRsp))) {
            unset($this->checkDealerRsp);
        } else {
            $this->checkDealerRsp = $checkDealerRsp;
        }
        return $this;
    }
    /**
     * Get responseHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\ResponseHeader|null
     */
    public function getResponseHeader()
    {
        return isset($this->responseHeader) ? $this->responseHeader : null;
    }
    /**
     * Set responseHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\ResponseHeader $responseHeader
     * @return \Payktm\StructType\ResponseCheckDealer
     */
    public function setResponseHeader(\Payktm\StructType\ResponseHeader $responseHeader = null)
    {
        if (is_null($responseHeader) || (is_array($responseHeader) && empty($responseHeader))) {
            unset($this->responseHeader);
        } else {
            $this->responseHeader = $responseHeader;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\ResponseCheckDealer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
