<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositConfig StructType
 * @subpackage Structs
 */
class DepositConfig extends AbstractStructBase
{
    /**
     * The accountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $accountNumber;
    /**
     * The attachmentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $attachmentType;
    /**
     * The configId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $configId;
    /**
     * The depositNum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $depositNum;
    /**
     * The district
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $district;
    /**
     * The maxQty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $maxQty;
    /**
     * The notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $notes;
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $region;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceType;
    /**
     * The zone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $zone;
    /**
     * Constructor method for DepositConfig
     * @uses DepositConfig::setAccountNumber()
     * @uses DepositConfig::setAttachmentType()
     * @uses DepositConfig::setConfigId()
     * @uses DepositConfig::setDepositNum()
     * @uses DepositConfig::setDistrict()
     * @uses DepositConfig::setMaxQty()
     * @uses DepositConfig::setNotes()
     * @uses DepositConfig::setRegion()
     * @uses DepositConfig::setServiceType()
     * @uses DepositConfig::setZone()
     * @param string $accountNumber
     * @param string $attachmentType
     * @param string $configId
     * @param string $depositNum
     * @param string $district
     * @param string $maxQty
     * @param string $notes
     * @param string $region
     * @param string $serviceType
     * @param string $zone
     */
    public function __construct($accountNumber = null, $attachmentType = null, $configId = null, $depositNum = null, $district = null, $maxQty = null, $notes = null, $region = null, $serviceType = null, $zone = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAttachmentType($attachmentType)
            ->setConfigId($configId)
            ->setDepositNum($depositNum)
            ->setDistrict($district)
            ->setMaxQty($maxQty)
            ->setNotes($notes)
            ->setRegion($region)
            ->setServiceType($serviceType)
            ->setZone($zone);
    }
    /**
     * Get accountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->accountNumber) ? $this->accountNumber : null;
    }
    /**
     * Set accountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \Payktm\StructType\DepositConfig
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->accountNumber);
        } else {
            $this->accountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get attachmentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachmentType()
    {
        return isset($this->attachmentType) ? $this->attachmentType : null;
    }
    /**
     * Set attachmentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachmentType
     * @return \Payktm\StructType\DepositConfig
     */
    public function setAttachmentType($attachmentType = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentType) && !is_string($attachmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentType)), __LINE__);
        }
        if (is_null($attachmentType) || (is_array($attachmentType) && empty($attachmentType))) {
            unset($this->attachmentType);
        } else {
            $this->attachmentType = $attachmentType;
        }
        return $this;
    }
    /**
     * Get configId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigId()
    {
        return isset($this->configId) ? $this->configId : null;
    }
    /**
     * Set configId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $configId
     * @return \Payktm\StructType\DepositConfig
     */
    public function setConfigId($configId = null)
    {
        // validation for constraint: string
        if (!is_null($configId) && !is_string($configId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($configId)), __LINE__);
        }
        if (is_null($configId) || (is_array($configId) && empty($configId))) {
            unset($this->configId);
        } else {
            $this->configId = $configId;
        }
        return $this;
    }
    /**
     * Get depositNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositNum()
    {
        return isset($this->depositNum) ? $this->depositNum : null;
    }
    /**
     * Set depositNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositNum
     * @return \Payktm\StructType\DepositConfig
     */
    public function setDepositNum($depositNum = null)
    {
        // validation for constraint: string
        if (!is_null($depositNum) && !is_string($depositNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositNum)), __LINE__);
        }
        if (is_null($depositNum) || (is_array($depositNum) && empty($depositNum))) {
            unset($this->depositNum);
        } else {
            $this->depositNum = $depositNum;
        }
        return $this;
    }
    /**
     * Get district value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistrict()
    {
        return isset($this->district) ? $this->district : null;
    }
    /**
     * Set district value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $district
     * @return \Payktm\StructType\DepositConfig
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($district)), __LINE__);
        }
        if (is_null($district) || (is_array($district) && empty($district))) {
            unset($this->district);
        } else {
            $this->district = $district;
        }
        return $this;
    }
    /**
     * Get maxQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxQty()
    {
        return isset($this->maxQty) ? $this->maxQty : null;
    }
    /**
     * Set maxQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxQty
     * @return \Payktm\StructType\DepositConfig
     */
    public function setMaxQty($maxQty = null)
    {
        // validation for constraint: string
        if (!is_null($maxQty) && !is_string($maxQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxQty)), __LINE__);
        }
        if (is_null($maxQty) || (is_array($maxQty) && empty($maxQty))) {
            unset($this->maxQty);
        } else {
            $this->maxQty = $maxQty;
        }
        return $this;
    }
    /**
     * Get notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->notes) ? $this->notes : null;
    }
    /**
     * Set notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \Payktm\StructType\DepositConfig
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->notes);
        } else {
            $this->notes = $notes;
        }
        return $this;
    }
    /**
     * Get region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegion()
    {
        return isset($this->region) ? $this->region : null;
    }
    /**
     * Set region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $region
     * @return \Payktm\StructType\DepositConfig
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        if (is_null($region) || (is_array($region) && empty($region))) {
            unset($this->region);
        } else {
            $this->region = $region;
        }
        return $this;
    }
    /**
     * Get serviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceType()
    {
        return isset($this->serviceType) ? $this->serviceType : null;
    }
    /**
     * Set serviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceType
     * @return \Payktm\StructType\DepositConfig
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        if (is_null($serviceType) || (is_array($serviceType) && empty($serviceType))) {
            unset($this->serviceType);
        } else {
            $this->serviceType = $serviceType;
        }
        return $this;
    }
    /**
     * Get zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZone()
    {
        return isset($this->zone) ? $this->zone : null;
    }
    /**
     * Set zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zone
     * @return \Payktm\StructType\DepositConfig
     */
    public function setZone($zone = null)
    {
        // validation for constraint: string
        if (!is_null($zone) && !is_string($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zone)), __LINE__);
        }
        if (is_null($zone) || (is_array($zone) && empty($zone))) {
            unset($this->zone);
        } else {
            $this->zone = $zone;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DepositConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
