<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerServiceSaveReq StructType
 * @subpackage Structs
 */
class DealerServiceSaveReq extends AbstractStructBase
{
    /**
     * The dealerService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerService[]
     */
    public $dealerService;
    /**
     * Constructor method for DealerServiceSaveReq
     * @uses DealerServiceSaveReq::setDealerService()
     * @param \Payktm\StructType\DealerService[] $dealerService
     */
    public function __construct(array $dealerService = array())
    {
        $this
            ->setDealerService($dealerService);
    }
    /**
     * Get dealerService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerService[]|null
     */
    public function getDealerService()
    {
        return isset($this->dealerService) ? $this->dealerService : null;
    }
    /**
     * Set dealerService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerService[] $dealerService
     * @return \Payktm\StructType\DealerServiceSaveReq
     */
    public function setDealerService(array $dealerService = array())
    {
        foreach ($dealerService as $dealerServiceSaveReqDealerServiceItem) {
            // validation for constraint: itemType
            if (!$dealerServiceSaveReqDealerServiceItem instanceof \Payktm\StructType\DealerService) {
                throw new \InvalidArgumentException(sprintf('The dealerService property can only contain items of \Payktm\StructType\DealerService, "%s" given', is_object($dealerServiceSaveReqDealerServiceItem) ? get_class($dealerServiceSaveReqDealerServiceItem) : gettype($dealerServiceSaveReqDealerServiceItem)), __LINE__);
            }
        }
        if (is_null($dealerService) || (is_array($dealerService) && empty($dealerService))) {
            unset($this->dealerService);
        } else {
            $this->dealerService = $dealerService;
        }
        return $this;
    }
    /**
     * Add item to dealerService value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerService $item
     * @return \Payktm\StructType\DealerServiceSaveReq
     */
    public function addToDealerService(\Payktm\StructType\DealerService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\DealerService) {
            throw new \InvalidArgumentException(sprintf('The dealerService property can only contain items of \Payktm\StructType\DealerService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dealerService[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerServiceSaveReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
