<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerServiceMaxQTYRsp StructType
 * @subpackage Structs
 */
class DealerServiceMaxQTYRsp extends AbstractStructBase
{
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * The unSelectService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\UnSelectService[]
     */
    public $unSelectService;
    /**
     * Constructor method for DealerServiceMaxQTYRsp
     * @uses DealerServiceMaxQTYRsp::setRespCode()
     * @uses DealerServiceMaxQTYRsp::setRespDesc()
     * @uses DealerServiceMaxQTYRsp::setUnSelectService()
     * @param string $respCode
     * @param string $respDesc
     * @param \Payktm\StructType\UnSelectService[] $unSelectService
     */
    public function __construct($respCode = null, $respDesc = null, array $unSelectService = array())
    {
        $this
            ->setRespCode($respCode)
            ->setRespDesc($respDesc)
            ->setUnSelectService($unSelectService);
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\DealerServiceMaxQTYRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\DealerServiceMaxQTYRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Get unSelectService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\UnSelectService[]|null
     */
    public function getUnSelectService()
    {
        return isset($this->unSelectService) ? $this->unSelectService : null;
    }
    /**
     * Set unSelectService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\UnSelectService[] $unSelectService
     * @return \Payktm\StructType\DealerServiceMaxQTYRsp
     */
    public function setUnSelectService(array $unSelectService = array())
    {
        foreach ($unSelectService as $dealerServiceMaxQTYRspUnSelectServiceItem) {
            // validation for constraint: itemType
            if (!$dealerServiceMaxQTYRspUnSelectServiceItem instanceof \Payktm\StructType\UnSelectService) {
                throw new \InvalidArgumentException(sprintf('The unSelectService property can only contain items of \Payktm\StructType\UnSelectService, "%s" given', is_object($dealerServiceMaxQTYRspUnSelectServiceItem) ? get_class($dealerServiceMaxQTYRspUnSelectServiceItem) : gettype($dealerServiceMaxQTYRspUnSelectServiceItem)), __LINE__);
            }
        }
        if (is_null($unSelectService) || (is_array($unSelectService) && empty($unSelectService))) {
            unset($this->unSelectService);
        } else {
            $this->unSelectService = $unSelectService;
        }
        return $this;
    }
    /**
     * Add item to unSelectService value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\UnSelectService $item
     * @return \Payktm\StructType\DealerServiceMaxQTYRsp
     */
    public function addToUnSelectService(\Payktm\StructType\UnSelectService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\UnSelectService) {
            throw new \InvalidArgumentException(sprintf('The unSelectService property can only contain items of \Payktm\StructType\UnSelectService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->unSelectService[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerServiceMaxQTYRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
