<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerCardReq StructType
 * @subpackage Structs
 */
class DealerCardReq extends AbstractStructBase
{
    /**
     * The dealerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dealerId;
    /**
     * The endNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $endNo;
    /**
     * The resourceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resourceType;
    /**
     * The startNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startNo;
    /**
     * Constructor method for DealerCardReq
     * @uses DealerCardReq::setDealerId()
     * @uses DealerCardReq::setEndNo()
     * @uses DealerCardReq::setResourceType()
     * @uses DealerCardReq::setStartNo()
     * @param string $dealerId
     * @param string $endNo
     * @param string $resourceType
     * @param string $startNo
     */
    public function __construct($dealerId = null, $endNo = null, $resourceType = null, $startNo = null)
    {
        $this
            ->setDealerId($dealerId)
            ->setEndNo($endNo)
            ->setResourceType($resourceType)
            ->setStartNo($startNo);
    }
    /**
     * Get dealerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerId()
    {
        return isset($this->dealerId) ? $this->dealerId : null;
    }
    /**
     * Set dealerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerId
     * @return \Payktm\StructType\DealerCardReq
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerId) && !is_string($dealerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerId)), __LINE__);
        }
        if (is_null($dealerId) || (is_array($dealerId) && empty($dealerId))) {
            unset($this->dealerId);
        } else {
            $this->dealerId = $dealerId;
        }
        return $this;
    }
    /**
     * Get endNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndNo()
    {
        return isset($this->endNo) ? $this->endNo : null;
    }
    /**
     * Set endNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endNo
     * @return \Payktm\StructType\DealerCardReq
     */
    public function setEndNo($endNo = null)
    {
        // validation for constraint: string
        if (!is_null($endNo) && !is_string($endNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endNo)), __LINE__);
        }
        if (is_null($endNo) || (is_array($endNo) && empty($endNo))) {
            unset($this->endNo);
        } else {
            $this->endNo = $endNo;
        }
        return $this;
    }
    /**
     * Get resourceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResourceType()
    {
        return isset($this->resourceType) ? $this->resourceType : null;
    }
    /**
     * Set resourceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resourceType
     * @return \Payktm\StructType\DealerCardReq
     */
    public function setResourceType($resourceType = null)
    {
        // validation for constraint: string
        if (!is_null($resourceType) && !is_string($resourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resourceType)), __LINE__);
        }
        if (is_null($resourceType) || (is_array($resourceType) && empty($resourceType))) {
            unset($this->resourceType);
        } else {
            $this->resourceType = $resourceType;
        }
        return $this;
    }
    /**
     * Get startNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartNo()
    {
        return isset($this->startNo) ? $this->startNo : null;
    }
    /**
     * Set startNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startNo
     * @return \Payktm\StructType\DealerCardReq
     */
    public function setStartNo($startNo = null)
    {
        // validation for constraint: string
        if (!is_null($startNo) && !is_string($startNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startNo)), __LINE__);
        }
        if (is_null($startNo) || (is_array($startNo) && empty($startNo))) {
            unset($this->startNo);
        } else {
            $this->startNo = $startNo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerCardReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
