<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerCardInfoReq StructType
 * @subpackage Structs
 */
class DealerCardInfoReq extends AbstractStructBase
{
    /**
     * The dealerCards
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerCard[]
     */
    public $dealerCards;
    /**
     * The dealerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dealerId;
    /**
     * Constructor method for DealerCardInfoReq
     * @uses DealerCardInfoReq::setDealerCards()
     * @uses DealerCardInfoReq::setDealerId()
     * @param \Payktm\StructType\DealerCard[] $dealerCards
     * @param string $dealerId
     */
    public function __construct(array $dealerCards = array(), $dealerId = null)
    {
        $this
            ->setDealerCards($dealerCards)
            ->setDealerId($dealerId);
    }
    /**
     * Get dealerCards value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerCard[]|null
     */
    public function getDealerCards()
    {
        return isset($this->dealerCards) ? $this->dealerCards : null;
    }
    /**
     * Set dealerCards value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerCard[] $dealerCards
     * @return \Payktm\StructType\DealerCardInfoReq
     */
    public function setDealerCards(array $dealerCards = array())
    {
        foreach ($dealerCards as $dealerCardInfoReqDealerCardsItem) {
            // validation for constraint: itemType
            if (!$dealerCardInfoReqDealerCardsItem instanceof \Payktm\StructType\DealerCard) {
                throw new \InvalidArgumentException(sprintf('The dealerCards property can only contain items of \Payktm\StructType\DealerCard, "%s" given', is_object($dealerCardInfoReqDealerCardsItem) ? get_class($dealerCardInfoReqDealerCardsItem) : gettype($dealerCardInfoReqDealerCardsItem)), __LINE__);
            }
        }
        if (is_null($dealerCards) || (is_array($dealerCards) && empty($dealerCards))) {
            unset($this->dealerCards);
        } else {
            $this->dealerCards = $dealerCards;
        }
        return $this;
    }
    /**
     * Add item to dealerCards value
     * @throws \InvalidArgumentException
     * @param \Payktm\StructType\DealerCard $item
     * @return \Payktm\StructType\DealerCardInfoReq
     */
    public function addToDealerCards(\Payktm\StructType\DealerCard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Payktm\StructType\DealerCard) {
            throw new \InvalidArgumentException(sprintf('The dealerCards property can only contain items of \Payktm\StructType\DealerCard, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dealerCards[] = $item;
        return $this;
    }
    /**
     * Get dealerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDealerId()
    {
        return isset($this->dealerId) ? $this->dealerId : null;
    }
    /**
     * Set dealerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dealerId
     * @return \Payktm\StructType\DealerCardInfoReq
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerId) && !is_string($dealerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dealerId)), __LINE__);
        }
        if (is_null($dealerId) || (is_array($dealerId) && empty($dealerId))) {
            unset($this->dealerId);
        } else {
            $this->dealerId = $dealerId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerCardInfoReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
