<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerCard StructType
 * @subpackage Structs
 */
class DealerCard extends AbstractStructBase
{
    /**
     * The cardNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cardNumber;
    /**
     * The resourceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resourceType;
    /**
     * Constructor method for DealerCard
     * @uses DealerCard::setCardNumber()
     * @uses DealerCard::setResourceType()
     * @param string $cardNumber
     * @param string $resourceType
     */
    public function __construct($cardNumber = null, $resourceType = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setResourceType($resourceType);
    }
    /**
     * Get cardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->cardNumber) ? $this->cardNumber : null;
    }
    /**
     * Set cardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \Payktm\StructType\DealerCard
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->cardNumber);
        } else {
            $this->cardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get resourceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResourceType()
    {
        return isset($this->resourceType) ? $this->resourceType : null;
    }
    /**
     * Set resourceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resourceType
     * @return \Payktm\StructType\DealerCard
     */
    public function setResourceType($resourceType = null)
    {
        // validation for constraint: string
        if (!is_null($resourceType) && !is_string($resourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resourceType)), __LINE__);
        }
        if (is_null($resourceType) || (is_array($resourceType) && empty($resourceType))) {
            unset($this->resourceType);
        } else {
            $this->resourceType = $resourceType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\DealerCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
