<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckMposNoIsRepeatRsp StructType
 * @subpackage Structs
 */
class CheckMposNoIsRepeatRsp extends AbstractStructBase
{
    /**
     * The mposNoNum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $mposNoNum;
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * Constructor method for CheckMposNoIsRepeatRsp
     * @uses CheckMposNoIsRepeatRsp::setMposNoNum()
     * @uses CheckMposNoIsRepeatRsp::setRespCode()
     * @uses CheckMposNoIsRepeatRsp::setRespDesc()
     * @param int $mposNoNum
     * @param string $respCode
     * @param string $respDesc
     */
    public function __construct($mposNoNum = null, $respCode = null, $respDesc = null)
    {
        $this
            ->setMposNoNum($mposNoNum)
            ->setRespCode($respCode)
            ->setRespDesc($respDesc);
    }
    /**
     * Get mposNoNum value
     * @return int|null
     */
    public function getMposNoNum()
    {
        return $this->mposNoNum;
    }
    /**
     * Set mposNoNum value
     * @param int $mposNoNum
     * @return \Payktm\StructType\CheckMposNoIsRepeatRsp
     */
    public function setMposNoNum($mposNoNum = null)
    {
        // validation for constraint: int
        if (!is_null($mposNoNum) && !is_numeric($mposNoNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mposNoNum)), __LINE__);
        }
        $this->mposNoNum = $mposNoNum;
        return $this;
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\CheckMposNoIsRepeatRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\CheckMposNoIsRepeatRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\CheckMposNoIsRepeatRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
