<?php

namespace Payktm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckDealerRsp StructType
 * @subpackage Structs
 */
class CheckDealerRsp extends AbstractStructBase
{
    /**
     * The dealerLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Payktm\StructType\DealerLogin
     */
    public $dealerLogin;
    /**
     * The respCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respCode;
    /**
     * The respDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $respDesc;
    /**
     * Constructor method for CheckDealerRsp
     * @uses CheckDealerRsp::setDealerLogin()
     * @uses CheckDealerRsp::setRespCode()
     * @uses CheckDealerRsp::setRespDesc()
     * @param \Payktm\StructType\DealerLogin $dealerLogin
     * @param string $respCode
     * @param string $respDesc
     */
    public function __construct(\Payktm\StructType\DealerLogin $dealerLogin = null, $respCode = null, $respDesc = null)
    {
        $this
            ->setDealerLogin($dealerLogin)
            ->setRespCode($respCode)
            ->setRespDesc($respDesc);
    }
    /**
     * Get dealerLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Payktm\StructType\DealerLogin|null
     */
    public function getDealerLogin()
    {
        return isset($this->dealerLogin) ? $this->dealerLogin : null;
    }
    /**
     * Set dealerLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Payktm\StructType\DealerLogin $dealerLogin
     * @return \Payktm\StructType\CheckDealerRsp
     */
    public function setDealerLogin(\Payktm\StructType\DealerLogin $dealerLogin = null)
    {
        if (is_null($dealerLogin) || (is_array($dealerLogin) && empty($dealerLogin))) {
            unset($this->dealerLogin);
        } else {
            $this->dealerLogin = $dealerLogin;
        }
        return $this;
    }
    /**
     * Get respCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCode()
    {
        return isset($this->respCode) ? $this->respCode : null;
    }
    /**
     * Set respCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCode
     * @return \Payktm\StructType\CheckDealerRsp
     */
    public function setRespCode($respCode = null)
    {
        // validation for constraint: string
        if (!is_null($respCode) && !is_string($respCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCode)), __LINE__);
        }
        if (is_null($respCode) || (is_array($respCode) && empty($respCode))) {
            unset($this->respCode);
        } else {
            $this->respCode = $respCode;
        }
        return $this;
    }
    /**
     * Get respDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespDesc()
    {
        return isset($this->respDesc) ? $this->respDesc : null;
    }
    /**
     * Set respDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respDesc
     * @return \Payktm\StructType\CheckDealerRsp
     */
    public function setRespDesc($respDesc = null)
    {
        // validation for constraint: string
        if (!is_null($respDesc) && !is_string($respDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDesc)), __LINE__);
        }
        if (is_null($respDesc) || (is_array($respDesc) && empty($respDesc))) {
            unset($this->respDesc);
        } else {
            $this->respDesc = $respDesc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Payktm\StructType\CheckDealerRsp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
